/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryInsertDeletePermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Editable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.type.Licence;
import at.mrdevelopment.toolkit.authentication.Role;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="ESL_LICENCE")
public class LicenceRecord
extends Record {
    public static final String LICENCE_KEY = "LICENCE_KEY";
    public static final String COMMENT = "COMMENT_STRING";
    private String comment;
    private String licenceKey;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryInsertDeletePermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public static LicenceRecord fromLicence(Licence licence) {
        return new LicenceRecord(licence.getComment(), licence.getLicenceKey());
    }

    public static Iterable<LicenceRecord> fromLicences(Iterable<Licence> licences) {
        return Iterables.transform(licences, (Function)new Function<Licence, LicenceRecord>(){

            public LicenceRecord apply(Licence licence) {
                return LicenceRecord.fromLicence(licence);
            }
        });
    }

    public LicenceRecord() {
    }

    public LicenceRecord(String comment, String licenceKey) {
        this.comment = comment;
        this.licenceKey = licenceKey;
    }

    @Column(name="CREATED_AT", nullable=false)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Serialize
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @Column(name="COMMENT_STRING", length=255, nullable=false)
    @Displayable(name="Comment", width=20, order=1)
    @Editable
    @Serialize
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name="LICENCE_KEY", length=32768, nullable=false)
    @Lob
    @Displayable(name="Encrypted Licence File Content", width=8, order=2)
    @Editable
    @Serialize
    public String getLicenceKey() {
        return this.licenceKey;
    }

    public void setLicenceKey(String licenceKey) {
        this.licenceKey = licenceKey;
    }

    @Transient
    public Licence toLicence() {
        return new Licence(this.comment, this.licenceKey);
    }
}

