/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryDeletePermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.annotation.UserType;
import at.mrdevelopment.esl.persistence.record.LabelIdRecord;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.persistence.record.UpdateImage;
import at.mrdevelopment.toolkit.authentication.Role;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="ESL_LABEL_PAGE_CONTENT")
public class LabelPageContent
extends Record
implements Serializable,
LabelIdRecord {
    public static final String ID = "ID";
    public static final String LABEL_SERIAL = "LABEL_SERIAL";
    public static final String PAGE = "PAGE";
    public static final String UPDATE_IMAGE_ID = "ESL_UPDATE_IMAGE_ID";
    private Long label;
    private Integer page;
    private UpdateImage updateImage;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryDeletePermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public LabelPageContent() {
    }

    public LabelPageContent(LabelId label, Page page, UpdateImage updateImage) {
        this.label = label.getId();
        this.page = page.getPageIndex();
        this.updateImage = updateImage;
    }

    @Column(name="CREATED_AT", nullable=false)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Serialize
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @Column(name="LABEL_SERIAL", nullable=false)
    @Index(name="IDX_PAGE_CONTENT_LABEL")
    @Displayable(name="Label ID", width=4, order=1)
    @UserType(value=LabelId.class)
    @Serialize(archive=true)
    public Long getLabel() {
        return this.label;
    }

    public void setLabel(Long label) {
        this.label = label;
    }

    @Column(name="PAGE", nullable=false)
    @Displayable(name="Page", width=1, filter=false, order=5)
    @UserType(value=Page.class)
    @Serialize(archive=true)
    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="ESL_UPDATE_IMAGE_ID")
    @ForeignKey(name="none")
    @NotFound(action=NotFoundAction.IGNORE)
    public UpdateImage getUpdateImage() {
        return this.updateImage;
    }

    public void setUpdateImage(UpdateImage updateImage) {
        this.updateImage = updateImage;
    }

    @Override
    @Transient
    public LabelId getLabelId() {
        return new LabelId(this.label);
    }

    @Override
    @Transient
    @Serialize
    public String getLabelIdString() {
        return this.getLabelId().getLabelIdString();
    }
}

