/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryDeletePermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SecurityStatus;
import at.mrdevelopment.esl.core.SyncQuality;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.annotation.UserType;
import at.mrdevelopment.esl.persistence.record.LabelIdRecord;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.type.LabelErrors;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.authentication.Role;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="ESL_LABEL_INFO_HISTORY")
public class LabelInfoHistoryRecord
extends Record
implements LabelIdRecord {
    private static final String LABEL_SERIAL = "LABEL_SERIAL";
    private static final String WAKEUP_TIME = "WAKEUP_TIME";
    private static final String LQI = "LQI";
    private static final String RSSI = "RSSI";
    private static final String POWER_STATUS = "POWER_STATUS";
    private static final String ACCESS_POINT_ID = "AP_ID";
    private static final String SYNC_QUALITY = "SYNC_QUALITY";
    private static final String LABEL_ERRORS = "LABEL_ERRORS";
    private static final String CURRENT_PAGE = "CURRENT_PAGE";
    private static final String SECURITY_STATUS = "SECURITY_STATUS";
    private static final String FIRMWARE_VERSION = "FIRMWARE_VERSION";
    private static final String CONNECTION_STATUS = "CONNECTION_STATUS";
    private static final String CALC_POWER_STATUS = "CALC_POWER_STATUS";
    private static final String CALC_POWER_STATUS_TIMESTAMP = "CALC_POWER_STATUS_TIMESTAMP";
    private Long label;
    private String firmwareVersion;
    private SecurityStatus securityStatus;
    private Integer currentPage;
    private PowerStatus internalPowerStatus;
    private Integer labelErrors;
    private Integer syncQuality;
    private Integer rssi;
    private Integer lqi;
    private Integer accessPointId;
    private DateTime wakeupTime;
    private ConnectionStatus connectionStatus;
    private PowerStatus calculatedPowerStatus;
    private DateTime calculatedPowerStatusTimestamp;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryDeletePermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public LabelInfoHistoryRecord() {
    }

    public LabelInfoHistoryRecord(LabelInfo labelInfo) {
        this.label = labelInfo.getLabel();
        this.firmwareVersion = labelInfo.getFirmwareVersion() != null ? labelInfo.getFirmwareVersion().getVersionString() : null;
        this.securityStatus = labelInfo.getSecurityStatus();
        this.currentPage = labelInfo.getCurrentPage() != null ? Integer.valueOf(labelInfo.getCurrentPage().getPageIndex()) : null;
        this.internalPowerStatus = labelInfo.getInternalPowerStatus();
        this.labelErrors = labelInfo.getLabelErrors() != null ? Integer.valueOf(labelInfo.getLabelErrors().getErrorCode()) : null;
        this.syncQuality = labelInfo.getSyncQuality() != null ? Integer.valueOf(labelInfo.getSyncQuality().getSyncQualityValue()) : null;
        this.rssi = labelInfo.getRssi();
        this.lqi = labelInfo.getLqi();
        this.accessPointId = labelInfo.getAccessPointId();
        this.wakeupTime = labelInfo.getWakeupTime();
        this.connectionStatus = labelInfo.getConnectionStatus();
        this.calculatedPowerStatus = labelInfo.getCalculatedPowerStatus() != null ? labelInfo.getCalculatedPowerStatusPower() : null;
        this.calculatedPowerStatusTimestamp = labelInfo.getCalculatedPowerStatus() != null ? labelInfo.getCalculatedPowerStatus().getTimestamp() : null;
    }

    @Column(name="CREATED_AT", nullable=false)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Index(name="IDX_ESL_LABEL_HISTORY_CREATED")
    @Serialize
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @Column(name="FIRMWARE_VERSION", length=8)
    @Displayable(name="Version", width=4, order=3)
    @UserType(value=Version.class)
    @Serialize(archive=true)
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    @Column(name="SECURITY_STATUS")
    @Displayable(name="Security Status", width=4, order=3)
    @UserType(value=SecurityStatus.class)
    @Serialize(archive=true)
    public SecurityStatus getSecurityStatus() {
        return this.securityStatus;
    }

    public void setSecurityStatus(SecurityStatus securityStatus) {
        this.securityStatus = securityStatus;
    }

    @Column(name="CONNECTION_STATUS")
    @Displayable(name="Connection Status", width=4, order=3)
    @UserType(value=ConnectionStatus.class)
    @Serialize(archive=true)
    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    @Column(name="CURRENT_PAGE", nullable=true)
    @Displayable(name="Page", width=1, filter=false, order=5)
    @UserType(value=Page.class)
    @Serialize(archive=true)
    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    @Column(name="LABEL_ERRORS")
    @Displayable(name="Label Errors", width=4, order=3)
    @UserType(value=LabelErrors.class)
    @Serialize(archive=true)
    public Integer getLabelErrors() {
        return this.labelErrors;
    }

    public void setLabelErrors(Integer labelErrors) {
        this.labelErrors = labelErrors;
    }

    @Column(name="SYNC_QUALITY")
    @Displayable(name="Sync Quality", width=4, order=3)
    @UserType(value=SyncQuality.class)
    @Serialize(archive=true)
    public Integer getSyncQuality() {
        return this.syncQuality;
    }

    public void setSyncQuality(Integer syncQuality) {
        this.syncQuality = syncQuality;
    }

    @Column(name="AP_ID", nullable=true)
    @Displayable(name="AP ID", width=2, order=53)
    @Serialize(archive=true)
    public Integer getAccessPointId() {
        return this.accessPointId;
    }

    public void setAccessPointId(Integer accessPointId) {
        this.accessPointId = accessPointId;
    }

    @Column(name="POWER_STATUS", nullable=true)
    @Displayable(name="Power", width=2, order=54)
    @UserType(value=PowerStatus.class)
    @Serialize(archive=true)
    public PowerStatus getInternalPowerStatus() {
        return this.internalPowerStatus;
    }

    public void setInternalPowerStatus(PowerStatus internalPowerStatus) {
        this.internalPowerStatus = internalPowerStatus;
    }

    @Column(name="RSSI", nullable=true)
    @Displayable(name="RSSI", width=1, filter=false, order=54)
    @Serialize(archive=true)
    public Integer getRssi() {
        return this.rssi;
    }

    public void setRssi(Integer rssi) {
        this.rssi = rssi;
    }

    @Column(name="LQI", nullable=true)
    @Displayable(name="LQI", width=1, filter=false, order=55)
    @Serialize(archive=true)
    public Integer getLqi() {
        return this.lqi;
    }

    public void setLqi(Integer lqi) {
        this.lqi = lqi;
    }

    @Column(name="WAKEUP_TIME")
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Displayable(name="Wakeup Time", width=4, order=5)
    @UserType(value=DateTime.class)
    @Serialize(archive=true)
    public DateTime getWakeupTime() {
        return this.wakeupTime;
    }

    public void setWakeupTime(DateTime wakeupTime) {
        this.wakeupTime = wakeupTime;
    }

    public void setLabel(Long label) {
        this.label = label;
    }

    @Column(name="LABEL_SERIAL", nullable=false)
    @Displayable(name="Label ID", width=4, order=1)
    @UserType(value=LabelId.class)
    @Serialize(archive=true)
    public Long getLabel() {
        return this.label;
    }

    @Column(name="CALC_POWER_STATUS", nullable=true)
    @UserType(value=PowerStatus.class)
    @Serialize(archive=true)
    public PowerStatus getCalculatedPowerStatus() {
        return this.calculatedPowerStatus != null ? this.calculatedPowerStatus : PowerStatus.UNKNOWN;
    }

    @Column(name="CALC_POWER_STATUS_TIMESTAMP", nullable=true)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @UserType(value=DateTime.class)
    @Serialize(archive=true)
    public DateTime getCalculatedPowerStatusTimestamp() {
        return this.calculatedPowerStatusTimestamp;
    }

    public void setCalculatedPowerStatus(PowerStatus calculatedPowerStatus) {
        this.calculatedPowerStatus = calculatedPowerStatus;
    }

    public void setCalculatedPowerStatusTimestamp(DateTime calculatedPowerStatusTimestamp) {
        this.calculatedPowerStatusTimestamp = calculatedPowerStatusTimestamp;
    }

    @Override
    @Serialize
    @Transient
    public String getLabelIdString() {
        return new LabelId(this.label).getLabelIdString();
    }

    @Override
    @Transient
    public LabelId getLabelId() {
        return new LabelId(this.label);
    }
}

