/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryDeletePermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.LabelIdRecord;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.authentication.Role;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="ESL_LABEL_EVENT")
public class LabelEventRecord
extends Record
implements LabelIdRecord {
    private static final String EVENT_ID = "EVENT_ID";
    private static final String LABEL = "LABEL";
    private static final String RECEIVED_TIME = "RECEIVED_TIME";
    private static final String EVENT_TYPE = "EVENT_TYPE";
    private static final String EVENT_DATA = "EVENT_DATA";
    private static final String EVENT_REVISION = "EVENT_REVISION";
    private static final String CONFIRMED = "CONFIRMED";
    private String eventId;
    private Long label;
    private DateTime receivedTime;
    private Integer eventType;
    private Integer eventData;
    private Integer eventRevision;
    private Boolean confirmed;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryDeletePermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public LabelEventRecord() {
    }

    public LabelEventRecord(LabelEvent labelEvent) {
        this.setEventId(labelEvent.getEventId().toString());
        this.setLabel(labelEvent.getLabelAddress().getHardwareAddress());
        this.setReceivedTime(labelEvent.getReceivedTime());
        this.setEventType(labelEvent.getEventType());
        this.setEventData(labelEvent.getEventData());
        this.setEventRevision(labelEvent.getRevision());
        this.setConfirmed(labelEvent.isConfirmed());
    }

    public static LabelEvent toLabelEvent(LabelEventRecord labelEventRecord) {
        return new LabelEvent(UUID.fromString(labelEventRecord.getEventId()), Address.fromId((long)labelEventRecord.getLabel()), labelEventRecord.getReceivedTime(), labelEventRecord.getEventType().intValue(), labelEventRecord.getEventData().intValue(), labelEventRecord.getEventRevision().intValue(), labelEventRecord.getConfirmed().booleanValue());
    }

    @Column(name="CREATED_AT", nullable=false)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Serialize
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @Column(name="EVENT_ID", nullable=false, unique=true)
    @Serialize(archive=true)
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    @Column(name="LABEL")
    public Long getLabel() {
        return this.label;
    }

    public void setLabel(Long label) {
        this.label = label;
    }

    @Column(name="RECEIVED_TIME")
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Serialize(archive=true)
    public DateTime getReceivedTime() {
        return this.receivedTime;
    }

    public void setReceivedTime(DateTime receivedTime) {
        this.receivedTime = receivedTime;
    }

    @Column(name="EVENT_TYPE")
    @Serialize(archive=true)
    public Integer getEventType() {
        return this.eventType;
    }

    public void setEventType(Integer eventType) {
        this.eventType = eventType;
    }

    @Column(name="EVENT_DATA")
    @Serialize(archive=true)
    public Integer getEventData() {
        return this.eventData;
    }

    public void setEventData(Integer eventData) {
        this.eventData = eventData;
    }

    @Column(name="EVENT_REVISION")
    @Serialize(archive=true)
    public Integer getEventRevision() {
        return this.eventRevision;
    }

    public void setEventRevision(Integer eventRevision) {
        this.eventRevision = eventRevision;
    }

    @Column(name="CONFIRMED")
    @Serialize(archive=true)
    public Boolean getConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(Boolean confirmed) {
        this.confirmed = confirmed;
    }

    @Override
    @Transient
    public LabelId getLabelId() {
        return new LabelId(this.label);
    }

    @Override
    @Transient
    @Serialize(archive=true)
    public String getLabelIdString() {
        return this.getLabelId().getLabelIdString();
    }

    public void updateWith(LabelEvent labelEvent) {
        this.setEventId(labelEvent.getEventId().toString());
        this.setLabel(labelEvent.getLabelAddress().getHardwareAddress());
        this.setReceivedTime(labelEvent.getReceivedTime());
        this.setEventType(labelEvent.getEventType());
        this.setEventData(labelEvent.getEventData());
        this.setEventRevision(labelEvent.getRevision());
        this.setConfirmed(labelEvent.isConfirmed());
    }
}

