/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryDeletePermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.annotation.UserType;
import at.mrdevelopment.esl.persistence.record.LabelIdRecord;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.type.LabelDetailType;
import at.mrdevelopment.esl.updatetask.LabelConfig;
import at.mrdevelopment.esl.updatetask.LabelCounter;
import at.mrdevelopment.esl.updatetask.LabelSensor;
import at.mrdevelopment.toolkit.authentication.Role;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="ESL_LABEL_DETAIL")
public class LabelDetail
extends Record
implements LabelIdRecord {
    public static final String LABEL_SERIAL = "LABEL_SERIAL";
    public static final String LABEL_DETAIL_TYPE = "DETAIL_TYPE";
    public static final String LABEL_DETAIL_ID = "DATA_ID";
    public static final String LABEL_DETAIL_VALUE = "DATA_VALUE";
    public static final String TASK_ID = "TASK_ID";
    private Long label;
    private LabelDetailType type;
    private Integer dataId;
    private Integer value;
    private UUID taskId;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryDeletePermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public LabelDetail() {
    }

    public LabelDetail(LabelId labelId, LabelDetailType type, Integer dataId, Integer value, UUID taskId) {
        this.dataId = dataId;
        this.value = value;
        this.label = labelId.getId();
        this.type = type;
        this.taskId = taskId;
        this.setCreatedAt(this.getCreatedAt() == null ? DateTime.now() : this.getCreatedAt());
        this.setUpdatedAt(DateTime.now());
    }

    @Column(name="CREATED_AT", nullable=false)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Index(name="IDX_ESL_LABEL_DETAIL_CREATED")
    @Serialize
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @Column(name="LABEL_SERIAL", nullable=false)
    @Index(name="IDX_ESL_LABEL_DETAIL_SERIAL")
    @Displayable(name="Label ID", width=4, order=1)
    @UserType(value=LabelId.class)
    @Serialize(archive=true)
    public Long getLabel() {
        return this.label;
    }

    public void setLabel(Long label) {
        this.label = label;
    }

    @Column(name="DATA_ID", nullable=false)
    @Serialize(archive=true)
    @Index(name="IDX_ESL_LABEL_DETAIL_DATA_ID")
    public Integer getDataId() {
        return this.dataId;
    }

    public void setDataId(Integer dataId) {
        this.dataId = dataId;
    }

    @Column(name="DATA_VALUE", nullable=true)
    @Displayable(name="Value", width=1, order=4)
    @Serialize(archive=true)
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    @Column(name="DETAIL_TYPE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @Displayable(name="Type", width=3, order=5)
    @Serialize(archive=true)
    @Index(name="IDX_DETAIL_TYPE")
    public LabelDetailType getType() {
        return this.type;
    }

    public void setType(LabelDetailType type) {
        this.type = type;
    }

    @Column(name="TASK_ID")
    @Index(name="IDX_ESL_LABEL_DETAIL_TASK_ID")
    @Type(type="uuid-char")
    public UUID getTaskId() {
        return this.taskId;
    }

    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    @Override
    @Transient
    public LabelId getLabelId() {
        return new LabelId(this.label);
    }

    @Override
    @Transient
    @Serialize
    public String getLabelIdString() {
        return this.getLabelId().getLabelIdString();
    }

    @Override
    @Transient
    @Serialize
    @Displayable(name="Name", width=6, order=3)
    public String getName() {
        if (this.dataId != null) {
            if (this.getType() == LabelDetailType.QUERY_COUNTER) {
                return LabelCounter.fromId((int)this.dataId).getCounterName();
            }
            if (this.getType() == LabelDetailType.QUERY_SENSOR) {
                return LabelSensor.fromId((int)this.dataId).getSensorName();
            }
            if (this.getType() == LabelDetailType.GET_CONFIG) {
                return LabelConfig.fromId((int)this.dataId).getConfigName();
            }
        }
        return null;
    }
}

