/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.BaseRecord;
import at.mrdevelopment.toolkit.authentication.Role;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class FontRecord
extends BaseRecord {
    public static final String PATTERN = ".+\\.(ttf|TTF|otf|OTF)";
    private Long id;
    private File fontFile;
    private String fontName;
    private String fontFamily;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public static SortedSet<String> toStrings(Collection<FontRecord> fonts) {
        return Sets.newTreeSet((Iterable)Iterables.transform(fonts, (Function)new Function<FontRecord, String>(){

            public String apply(FontRecord template) {
                return template.getName();
            }
        }));
    }

    public FontRecord() {
    }

    public FontRecord(long id, String fontName, File fontFile, String fontFamily) {
        this.id = id;
        this.fontName = fontName;
        this.fontFile = fontFile;
        this.fontFamily = fontFamily;
    }

    @Serialize
    @Displayable(name="Font file", width=5)
    public String getFontFilename() {
        return this.fontFile != null ? this.fontFile.getName() : "";
    }

    @Serialize
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Serialize
    @Displayable(name="Font family", width=5)
    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    @Serialize
    @Displayable(name="Font name", width=5)
    public String getIdentifier() {
        return this.fontName;
    }

    public void setIdentifier(String identifier) {
        this.fontName = identifier;
    }

    @Serialize
    @Displayable(name="System font", width=2)
    public boolean isSystemFont() {
        return this.fontFile == null;
    }

    public String getName() {
        return this.fontName;
    }

    public File getFontFile() {
        return this.fontFile;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        FontRecord otherRecord = (FontRecord)((Object)obj);
        return new EqualsBuilder().append((Object)this.getIdentifier(), (Object)otherRecord.getIdentifier()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 37).append((Object)this.getIdentifier()).toHashCode();
    }
}

