/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.BaseRecord;
import at.mrdevelopment.toolkit.authentication.Role;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;

public class FirmwareRecord
extends BaseRecord {
    private Long id;
    private String firmwareFilename;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public static SortedSet<String> toStrings(Collection<FirmwareRecord> firmwareFiles) {
        return Sets.newTreeSet((Iterable)Iterables.transform(firmwareFiles, (Function)new Function<FirmwareRecord, String>(){

            public String apply(FirmwareRecord firmware) {
                return firmware.getName();
            }
        }));
    }

    public FirmwareRecord() {
    }

    public FirmwareRecord(long id, String firmwareFilename) {
        this.id = id;
        this.firmwareFilename = firmwareFilename;
    }

    @Displayable(name="Firmware file", width=5)
    @Serialize
    public String getFirmwareFilename() {
        return this.firmwareFilename;
    }

    public void setFirmwareFilename(String firmwareFilename) {
        this.firmwareFilename = firmwareFilename;
    }

    @Serialize
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Serialize
    public String getIdentifier() {
        return this.firmwareFilename;
    }

    public String getName() {
        return this.firmwareFilename;
    }
}

