/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.authentication.QueryUpdatePermissions;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Editable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.type.BasicType;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.BooleanUtils;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="ESL_CONFIGURATION")
public class Configuration
extends Record {
    public static final String KEY = "CONFIG_KEY";
    public static final String TYPE = "TYPE";
    public static final String DEFAULT_VALUE = "DEFAULT_VALUE";
    public static final String VALUE = "VALUE";
    private String key;
    private BasicType type;
    private String defaultValue;
    private String value;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryUpdatePermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public static List<Configuration> filterModified(Iterable<Configuration> records) {
        return Lists.newArrayList((Iterable)Iterables.filter(records, (Predicate)new Predicate<Configuration>(){

            public boolean apply(Configuration entry) {
                return !entry.isDefault();
            }
        }));
    }

    public Configuration() {
    }

    public Configuration(String key, BasicType type, String defaultValue, String value) {
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue;
        this.value = value;
    }

    @Column(name="CREATED_AT", nullable=false)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Serialize
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @Column(name="CONFIG_KEY", nullable=false, unique=true)
    @Displayable(name="Name", width=7, order=1)
    @Serialize
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Column(name="TYPE", nullable=false)
    @Displayable(name="Type", width=3, order=2)
    @Enumerated(value=EnumType.STRING)
    @Serialize
    public BasicType getType() {
        return this.type;
    }

    public void setType(BasicType type) {
        this.type = type;
    }

    @Column(name="DEFAULT_VALUE", nullable=true, length=1023)
    @Displayable(name="Default", width=3, order=3)
    @Serialize
    public String getDefaultValue() {
        return Strings.nullToEmpty((String)this.defaultValue);
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Column(name="VALUE", nullable=true, length=1023)
    @Displayable(name="Value", width=3, order=4)
    @Editable
    @Serialize
    public String getValue() {
        return Strings.nullToEmpty((String)this.value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Transient
    public void validate() throws SerializeException {
        this.getParsedValue();
    }

    @Transient
    public Object getParsedValue() throws SerializeException {
        try {
            if (this.type == BasicType.INTEGER) {
                return Integer.parseInt(this.value);
            }
            if (this.type == BasicType.BOOLEAN) {
                return BooleanUtils.toBoolean((String)this.value, (String)"true", (String)"false");
            }
            if (this.type == BasicType.FLOAT) {
                return Float.valueOf(Float.parseFloat(this.value));
            }
            if (this.type == BasicType.STRING) {
                return this.value;
            }
            throw new SerializeException("Could not convert value '%s' to unknown type %s", new Object[]{this.value, this.type.toString()});
        }
        catch (Exception exc) {
            throw new SerializeException("Could not convert value '%s' to type %s", new Object[]{this.value, this.type.toString()});
        }
    }

    @Override
    @Transient
    public String getName() {
        return this.key;
    }

    @Transient
    public boolean isDefault() {
        return Objects.equal((Object)this.value, (Object)this.defaultValue);
    }
}

