/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryDeletePermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.core.AccessPointUpdateStatus;
import at.mrdevelopment.esl.core.AccessPointUpdateType;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.annotation.UserType;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.type.AccessPointUpdateError;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.authentication.Role;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="ESL_AP_UPDATE")
public class AccessPointUpdateRecord
extends Record {
    private static final String AP_ID = "AP_ID";
    private static final String AP_VERSION = "AP_VERSION";
    private static final String UPDATE_HASH = "UPDATE_HASH";
    private static final String RETRIES_LEFT = "RETRIES_LEFT";
    private static final String ERROR_CODE = "ERROR_CODE";
    private static final String STATUS = "STATUS";
    private static final String UPDATE_TYPE = "UPDATE_TYPE";
    private Integer accessPointId;
    private AccessPointUpdateType updateType;
    private String accessPointVersion;
    private byte[] updateHash;
    private Integer retriesLeft;
    private AccessPointUpdateError updateError;
    private AccessPointUpdateStatus status;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryDeletePermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public AccessPointUpdateRecord() {
    }

    public AccessPointUpdateRecord(Integer accessPointId, AccessPointUpdateType updateType, Version accessPointVersion, byte[] updateHash, int retriesLeft, AccessPointUpdateStatus status) {
        this.accessPointId = accessPointId;
        this.updateType = updateType;
        this.accessPointVersion = accessPointVersion != null ? accessPointVersion.getVersionString() : Version.UNDEFINED.getVersionString();
        this.updateHash = updateHash;
        this.retriesLeft = retriesLeft;
        this.status = status;
    }

    @Column(name="CREATED_AT", nullable=false)
    @Type(type="org.joda.time.contrib.hibernate.PersistentDateTime")
    @Serialize
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @Column(name="AP_ID", nullable=false)
    @Displayable(name="AP ID", width=3, order=1)
    @Serialize
    public Integer getAccessPointId() {
        return this.accessPointId;
    }

    public void setAccessPointId(Integer accessPointId) {
        this.accessPointId = accessPointId;
    }

    @Column(name="UPDATE_TYPE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @Displayable(name="Update Type", width=3, order=4)
    @Serialize(archive=true)
    public AccessPointUpdateType getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(AccessPointUpdateType updateType) {
        this.updateType = updateType;
    }

    @Column(name="AP_VERSION", length=16)
    @Displayable(name="AP Version", width=4, order=3)
    @UserType(value=Version.class)
    @Serialize
    public String getAccessPointVersion() {
        return this.accessPointVersion;
    }

    public void setAccessPointVersion(String accessPointVersion) {
        this.accessPointVersion = accessPointVersion;
    }

    @Transient
    public Version getVersion() {
        return this.accessPointVersion == null ? null : Version.fromString((String)this.accessPointVersion);
    }

    @Column(name="UPDATE_HASH", length=64)
    @Displayable(name="Update Hash", width=4, order=3)
    public byte[] getUpdateHash() {
        return this.updateHash;
    }

    public void setUpdateHash(byte[] updateHash) {
        this.updateHash = updateHash;
    }

    @Column(name="RETRIES_LEFT", nullable=false)
    @Index(name="IDX_RETRIES_LEFTESL_AP_UPDATE")
    @Displayable(name="Retries Left", width=1, filter=false, order=57)
    @Serialize
    public Integer getRetriesLeft() {
        return this.retriesLeft;
    }

    public void setRetriesLeft(Integer retriesLeft) {
        this.retriesLeft = retriesLeft;
    }

    @Column(name="ERROR_CODE", nullable=true)
    @Serialize
    public Integer getErrorCode() {
        return this.updateError != null ? Integer.valueOf(this.updateError.getCode()) : null;
    }

    public void setErrorCode(Integer errorCode) {
        this.updateError = errorCode != null ? AccessPointUpdateError.valueOf(errorCode) : null;
    }

    public void setUpdateError(AccessPointUpdateError updateError) {
        this.updateError = updateError;
    }

    @Transient
    @Displayable(name="Update Error", width=1, filter=false, order=57)
    public AccessPointUpdateError getUpdateError() {
        return this.updateError;
    }

    @Column(name="STATUS", nullable=false)
    @Index(name="IDX_STATUSESL_AP_UPDATE")
    @Enumerated(value=EnumType.STRING)
    @Displayable(name="Task Status", width=4, order=50)
    @Serialize
    public AccessPointUpdateStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccessPointUpdateStatus status) {
        this.status = status;
    }

    @Transient
    public boolean hasRetriesLeft() {
        return this.retriesLeft > 0;
    }
}

