/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.BaseRecord;
import at.mrdevelopment.esl.update.UpdatePackageInformation;
import at.mrdevelopment.toolkit.RequiredVersion;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.authentication.Role;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class AccessPointUpdatePackageRecord
extends BaseRecord {
    private Long id;
    private File updatePackageFile;
    private UpdatePackageInformation packageInformation;
    private byte[] checksum;
    private long size;
    private int webserverListenPort;
    private boolean webserverSsl;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public static SortedSet<String> toStrings(Collection<AccessPointUpdatePackageRecord> fonts) {
        return Sets.newTreeSet((Iterable)Iterables.transform(fonts, (Function)new Function<AccessPointUpdatePackageRecord, String>(){

            public String apply(AccessPointUpdatePackageRecord updateRecord) {
                return updateRecord.getName();
            }
        }));
    }

    public AccessPointUpdatePackageRecord() {
    }

    public AccessPointUpdatePackageRecord(long id, UpdatePackageInformation packageInformation, File updatePackageFile, byte[] checksum, int webserverListenPort, boolean webserverSsl) {
        this.id = id;
        this.packageInformation = packageInformation;
        this.updatePackageFile = updatePackageFile;
        this.checksum = checksum;
        this.webserverListenPort = webserverListenPort;
        this.webserverSsl = webserverSsl;
        this.size = updatePackageFile.length();
    }

    @Serialize
    @Displayable(name="Update file", width=5)
    public String getUpdatePackageFileName() {
        return this.updatePackageFile != null ? this.updatePackageFile.getName() : "";
    }

    @Serialize
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Serialize
    @Displayable(name="Update file name", width=5)
    public String getIdentifier() {
        return this.getUpdatePackageFileName();
    }

    public String getName() {
        return this.getIdentifier();
    }

    public File getUpdatePackageFile() {
        return this.updatePackageFile;
    }

    @Serialize
    public DeviceMode getDeviceMode() {
        return this.packageInformation.getDeviceMode();
    }

    @Serialize
    public Version getUpdateVersion() {
        return this.packageInformation.getVersion();
    }

    @Serialize
    public RequiredVersion getRequiredVersion() {
        return this.packageInformation.getRequiredVersion();
    }

    @Serialize
    public String getAccessPointType() {
        return this.packageInformation.getTypeIdentifier();
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    @Serialize
    public long getSize() {
        return this.size;
    }

    @Transient
    public int getWebserverListenPort() {
        return this.webserverListenPort;
    }

    @Transient
    public boolean isWebserverSsl() {
        return this.webserverSsl;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        AccessPointUpdatePackageRecord otherRecord = (AccessPointUpdatePackageRecord)((Object)obj);
        return new EqualsBuilder().append((Object)this.getIdentifier(), (Object)otherRecord.getIdentifier()).isEquals() && Arrays.equals(this.getChecksum(), otherRecord.getChecksum());
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 37).append((Object)this.getIdentifier()).toHashCode();
    }
}

