/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.authentication.FullPermissions;
import at.mrdevelopment.esl.authentication.NoPermissions;
import at.mrdevelopment.esl.authentication.QueryPermissions;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.BaseRecord;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.authentication.Role;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.validator.routines.UrlValidator;
import org.joda.time.DateTime;

public class AccessPointInfo
extends BaseRecord {
    private static final UrlValidator VALIDATOR = new UrlValidator(new String[]{"http", "https"});
    private transient boolean isNewEntry;
    private transient boolean serviceToBeInitialized = false;
    private transient boolean serviceInitialized = false;
    private transient String apAddress;
    private transient long discoveryTimeInMillis;
    private Integer localPort;
    private String name;
    private Integer accessPointId;
    private String serial;
    private String address;
    private String managementAddress;
    private WirelessChannel channel;
    private ConnectionStatus connectionStatus;
    private Version version;
    private DateTime updateTime;
    private Boolean autoConfig;
    private String server;
    private String typeIdentifier;
    private String protocol;
    private AccessPointServiceStatus serviceStatus;

    public static Map<Role, DatasetPermissions> getDatasetPermissions() {
        HashMap<Role, DatasetPermissions> datasetPermissions = new HashMap<Role, DatasetPermissions>();
        datasetPermissions.put(Role.SYSTEM, FullPermissions.INSTANCE);
        datasetPermissions.put(Role.ADMIN, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.USER, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.READONLY, QueryPermissions.INSTANCE);
        datasetPermissions.put(Role.NONE, NoPermissions.INSTANCE);
        return datasetPermissions;
    }

    public static AccessPointInfo createOffline(int accessPointId) {
        return new AccessPointInfo(accessPointId, ServiceAddress.DEFAULT_INVALID, ServiceAddress.DEFAULT_INVALID, null, ConnectionStatus.OFFLINE, null, DateTime.now(), false);
    }

    public static AccessPointInfo createOffline(int accessPointId, ServiceAddress serviceAddress) {
        return new AccessPointInfo(accessPointId, serviceAddress, null, null, ConnectionStatus.OFFLINE, null, DateTime.now(), false);
    }

    public static AccessPointInfo createOffline(int accessPointId, ServiceAddress serviceAddress, ServiceAddress apAddress, ServiceAddress managementAddress, Boolean autoConfig) {
        return new AccessPointInfo(accessPointId, serviceAddress, apAddress, managementAddress, ConnectionStatus.OFFLINE, null, DateTime.now(), autoConfig);
    }

    public static AccessPointInfo createDiscovered(int accessPointId, ServiceAddress serviceAddress, ServiceAddress managementAddress, Version version, Boolean autoConfig) {
        return new AccessPointInfo(accessPointId, serviceAddress, null, managementAddress, ConnectionStatus.DISCOVERED, version, DateTime.now(), autoConfig);
    }

    public AccessPointInfo() {
        this.isNewEntry = true;
        this.localPort = null;
    }

    private AccessPointInfo(int accessPointId, ServiceAddress serviceAddress, ServiceAddress apAddress, ServiceAddress managementAddress, ConnectionStatus connectionStatus, Version version, DateTime updateTime, Boolean autoConfig) {
        this.accessPointId = accessPointId;
        this.name = null;
        this.address = serviceAddress.toString();
        this.apAddress = apAddress != null ? apAddress.toString() : "";
        this.managementAddress = managementAddress != null ? managementAddress.toString() : "";
        this.connectionStatus = connectionStatus;
        this.version = version;
        this.updateTime = updateTime;
        this.autoConfig = autoConfig;
        this.isNewEntry = true;
        this.localPort = null;
        this.typeIdentifier = AccessPointTypeMapping.getType((int)accessPointId).name();
    }

    @Serialize
    public Long getId() {
        return (long)this.accessPointId;
    }

    public void setId(Long id) {
        this.accessPointId = id.intValue();
    }

    public String getIdentifier() {
        return this.name;
    }

    @Displayable(name="AP ID", width=2, order=1)
    @Serialize(archive=true)
    public Integer getAccessPointId() {
        return this.accessPointId;
    }

    public void setAccessPointId(Integer accessPointId) {
        this.accessPointId = accessPointId;
    }

    @Displayable(name="Hostname", width=4, order=2)
    @Serialize(archive=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Displayable(name="Serial", width=4, order=3)
    @Serialize(archive=true)
    public String getSerial() {
        return this.serial;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    @Serialize
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getApAddress() {
        return this.apAddress;
    }

    public void setApAddress(String address) {
        this.apAddress = address;
    }

    @Serialize
    public String getManagementAddress() {
        if (VALIDATOR.isValid(this.managementAddress)) {
            return this.managementAddress;
        }
        return "";
    }

    public void setManagementAddress(String managementAddress) {
        this.managementAddress = managementAddress;
    }

    @Displayable(name="Server", width=4, order=4)
    @Serialize(archive=true)
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    @Displayable(name="Channel", width=2, filter=false, order=5)
    @Serialize(archive=true)
    public WirelessChannel getChannel() {
        return this.channel;
    }

    public void setChannel(WirelessChannel channel) {
        this.channel = channel;
    }

    @Displayable(name="Status", width=4, order=90)
    @Serialize(archive=true)
    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public boolean isOnline() {
        return this.connectionStatus.isOnline();
    }

    public boolean isOffline() {
        return this.connectionStatus.isOffline();
    }

    public boolean isDiscovered() {
        return this.connectionStatus.isDiscovered();
    }

    public boolean isServiceInitialized() {
        return this.serviceInitialized;
    }

    public void setServiceInitialized(boolean serviceInitialized) {
        this.serviceInitialized = serviceInitialized;
    }

    public boolean isServiceToBeInitialized() {
        return this.serviceToBeInitialized;
    }

    public void setServiceToBeInitialized(boolean serviceToBeInitialized) {
        this.serviceToBeInitialized = serviceToBeInitialized;
    }

    public long getDiscoveryTime() {
        return this.discoveryTimeInMillis;
    }

    public void setDiscoveryTime(long timeInMillis) {
        this.discoveryTimeInMillis = timeInMillis;
    }

    @Displayable(name="Centralized mode enabled", width=2, filter=false, order=10)
    @Serialize(archive=true)
    public Boolean getAutoConfig() {
        return this.autoConfig;
    }

    public void setAutoConfig(Boolean autoConfig) {
        this.autoConfig = autoConfig;
    }

    @Displayable(name="Version", width=2, filter=false, order=11)
    @Serialize(archive=true)
    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    @Displayable(name="Last Update", width=4, filter=false, order=12)
    @Serialize(archive=true)
    public DateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(DateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Displayable(name="Local port", width=5, filter=false, order=13)
    @Serialize(archive=true)
    public Integer getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(Integer port) {
        this.localPort = port;
    }

    @Displayable(name="Type", width=5, filter=false, order=14)
    @Serialize(archive=false)
    public String getTypeIdentifier() {
        return this.typeIdentifier;
    }

    public void setTypeIdentifier(String typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }

    @Displayable(name="Protocol", width=5, filter=false, order=15)
    @Serialize(archive=true)
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public AccessPointServiceStatus getServiceStatus() {
        return this.serviceStatus;
    }

    public void setServiceStatus(AccessPointServiceStatus serviceStatus) {
        this.serviceStatus = serviceStatus;
        if (serviceStatus != null) {
            this.name = serviceStatus.getHostname();
            this.serial = serviceStatus.getSerial();
            this.channel = serviceStatus.getChannel();
            this.server = serviceStatus.getServer();
            this.autoConfig = serviceStatus.isAutoConfig();
            this.version = serviceStatus.getVersion();
            this.updateTime = DateTime.now();
        }
    }

    public boolean isNew() {
        return this.isNewEntry;
    }

    public void setNotNew() {
        this.isNewEntry = false;
    }
}

