/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.persistence.AccessException;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.DatasetField;
import at.mrdevelopment.esl.persistence.DatasetListener;
import at.mrdevelopment.esl.persistence.DatasetModifiedListener;
import at.mrdevelopment.esl.persistence.DatasetReloadListener;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.ListDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryUrlRegistry;
import at.mrdevelopment.esl.persistence.query.ScrollableQueryResult;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.toolkit.Abortable;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDataset<T extends Commitable>
implements Dataset<T> {
    static ESLLogger logger = ESLLogger.getLogger(AbstractDataset.class);
    private final Class<T> recordClass;
    private final Map<Role, DatasetPermissions> datasetPermissions;
    private final Collection<DatasetField> datasetFields;
    private final List<String> customFields;
    private final Set<DatasetListener<T>> datasetListeners = new HashSet<DatasetListener<T>>();
    private final Set<DatasetModifiedListener<T>> datasetModifiedListeners = new HashSet<DatasetModifiedListener<T>>();
    private final Set<DatasetReloadListener> datasetReloadListeners = new HashSet<DatasetReloadListener>();

    public AbstractDataset(Class<T> recordClass, Map<Role, DatasetPermissions> datasetPermissions) throws InitializationException {
        this(recordClass, datasetPermissions, new ArrayList<String>(0));
    }

    public AbstractDataset(Class<T> recordClass, Map<Role, DatasetPermissions> datasetPermissions, List<String> customFields) throws InitializationException {
        this.recordClass = recordClass;
        this.datasetPermissions = datasetPermissions;
        this.datasetFields = DatasetField.getDatasetFields(recordClass, customFields);
        this.customFields = customFields;
    }

    public DatasetQuery<T, Void> getDefaultQuery() {
        return new ListDatasetQuery<T, Void>(QueryUrlRegistry.getDefaultQueryUrl(this.recordClass), this.recordClass, Void.class){

            protected List<T> getRecords(Void searchKey, Transaction<?> transaction) throws DatasetException {
                return AbstractDataset.this.queryAll(transaction);
            }
        };
    }

    public Class<T> getRecordClass() {
        return this.recordClass;
    }

    public T newRecord() throws DatasetException {
        try {
            return (T)((Commitable)this.recordClass.newInstance());
        }
        catch (InstantiationException exc) {
            throw new DatasetException((Throwable)exc);
        }
        catch (IllegalAccessException exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public List<T> queryPage(int page, int recordsPerPage, Transaction<?> transaction) throws DatasetException {
        return new ScrollableQueryResult(this.queryAll(transaction)).getResultsForPage(page, recordsPerPage).getRecords();
    }

    public void store(T record, UserId user, Transaction<?> transaction) throws DatasetException {
        this.store(Collections.singleton(record), user, transaction);
        if (record.getCommitState().isUnmodified()) {
            throw new DatasetException("Failed to store record of type %s with ID %s", new Object[]{record.getClass().getSimpleName(), record.getId()});
        }
    }

    public void delete(T record, UserId user, Transaction<?> transaction) throws DatasetException {
        this.delete(Collections.singleton(record), user, transaction);
        if (record.getCommitState().isUnmodified()) {
            throw new DatasetException("Failed to delete record of type %s with ID %s", new Object[]{record.getClass().getSimpleName(), record.getId()});
        }
    }

    public void refresh(T record, Transaction<?> transaction) throws DatasetException {
        this.refresh(record, transaction);
    }

    public void clear(Transaction<?> transaction) throws DatasetException {
        this.clear(transaction);
    }

    public Abortable reload(Transaction<?> transaction) throws DatasetException {
        return this.reload(transaction);
    }

    public void addDatasetListener(DatasetListener<T> listener) {
        this.datasetListeners.add(listener);
    }

    public void removeDatasetListener(DatasetListener<T> listener) {
        this.datasetListeners.remove(listener);
    }

    public void addDatasetModifiedListener(DatasetModifiedListener<T> listener) {
        this.datasetModifiedListeners.add(listener);
    }

    public void removeDatasetModifiedListener(DatasetModifiedListener<T> listener) {
        this.datasetModifiedListeners.remove(listener);
    }

    public void addDatasetReloadListener(DatasetReloadListener listener) {
        this.datasetReloadListeners.add(listener);
    }

    public void removeDatasetReloadListener(DatasetReloadListener listener) {
        this.datasetReloadListeners.remove(listener);
    }

    public Collection<DatasetField> getDatasetFields() {
        return this.datasetFields;
    }

    public DatasetField getDatasetField(String internalName) {
        for (DatasetField datasetField : this.datasetFields) {
            if (!datasetField.getInternalName().equals(internalName)) continue;
            return datasetField;
        }
        return null;
    }

    public List<String> getCustomFields() {
        return Collections.unmodifiableList(this.customFields);
    }

    public boolean hasDefaultQuery() {
        return true;
    }

    public boolean hasInsertPermission(Role role) {
        return this.datasetPermissions.get(role).hasInsertPermission();
    }

    public boolean hasUpdatePermission(Role role) {
        return this.datasetPermissions.get(role).hasUpdatePermission();
    }

    public boolean hasDeletePermission(Role role) {
        return this.datasetPermissions.get(role).hasDeletePermission();
    }

    public boolean hasQueryPermission(Role role) {
        return this.datasetPermissions.get(role).hasQueryPermission();
    }

    public void recordsModified(Collection<T> records, Transaction<?> transaction) {
    }

    protected void notifyRecordInsert(T record, Transaction<?> transaction) throws DatasetException {
        for (DatasetListener<T> listener : this.datasetListeners) {
            listener.recordInsert(record, transaction);
        }
    }

    protected void notifyRecordUpdate(T record, Transaction<?> transaction) throws DatasetException {
        for (DatasetListener<T> listener : this.datasetListeners) {
            listener.recordUpdate(record, transaction);
        }
    }

    protected void notifyRecordDelete(T record, Transaction<?> transaction) throws DatasetException {
        for (DatasetListener<T> listener : this.datasetListeners) {
            listener.recordDelete(record, transaction);
        }
    }

    protected void notifyRecordsModified(Collection<T> records, Transaction<?> transaction) {
        for (DatasetModifiedListener<T> listener : this.datasetModifiedListeners) {
            listener.recordsModified(records, transaction);
        }
    }

    protected void notifyReloadInitialized(Abortable reloadAbortable) {
        for (DatasetReloadListener listener : this.datasetReloadListeners) {
            listener.reloadInitialized(reloadAbortable);
        }
    }

    protected void notifyReloadFinished() {
        for (DatasetReloadListener listener : this.datasetReloadListeners) {
            listener.reloadFinished();
        }
    }

    protected void notifyReloadFailed() {
        for (DatasetReloadListener listener : this.datasetReloadListeners) {
            listener.reloadFailed();
        }
    }

    protected void notifyReloadAborted() {
        for (DatasetReloadListener listener : this.datasetReloadListeners) {
            listener.reloadAborted();
        }
    }

    protected void checkInsertPermission(Role role) throws DatasetException {
        if (!this.hasInsertPermission(role)) {
            throw AccessException.INSERT;
        }
    }

    protected void checkUpdatePermission(Role role) throws DatasetException {
        if (!this.hasUpdatePermission(role)) {
            throw AccessException.UPDATE;
        }
    }

    protected void checkStorePermission(Role role) throws DatasetException {
        if (!this.hasInsertPermission(role) && !this.hasUpdatePermission(role)) {
            throw AccessException.UPDATE;
        }
    }

    protected void checkDeletePermission(Role role) throws DatasetException {
        if (!this.hasDeletePermission(role)) {
            throw AccessException.DELETE;
        }
    }

    protected void checkQueryPermission(Role role) throws DatasetException {
        if (!this.hasQueryPermission(role)) {
            throw AccessException.QUERY;
        }
    }
}

