/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.RecordXMLSerializer;
import at.mrdevelopment.esl.persistence.dataset.PagedDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.AbstractDataset;
import at.mrdevelopment.esl.persistence.record.CommitState;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.toolkit.Abortable;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.gui.RecordsPerPage;
import at.mrdevelopment.toolkit.http.HttpServiceClient;
import at.mrdevelopment.toolkit.http.RequestFailedHandler;
import at.mrdevelopment.toolkit.http.ResponseHandler;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public abstract class WebserviceDataset<T extends Commitable>
extends AbstractDataset<T>
implements PagedDataset<T> {
    static ESLLogger logger = ESLLogger.getLogger(WebserviceDataset.class);
    protected final HttpServiceClient httpServiceClient;
    protected final RecordXMLSerializer<T> recordSerializer;
    private final Map<Long, T> records = new HashMap<Long, T>();
    private final List<Long> recordIds = new ArrayList<Long>();
    private int totalRecords = 0;
    private int totalPages = 0;
    private int currentPage = 0;
    private RecordsPerPage recordsPerPage = RecordsPerPage.SYSTEM_DEFAULT;

    public WebserviceDataset(HttpServiceClient httpServiceClient, Class<T> recordClass, Map<Role, DatasetPermissions> datasetPermissions, List<String> customFields) throws InitializationException {
        super(recordClass, datasetPermissions, customFields);
        this.httpServiceClient = httpServiceClient;
        this.recordSerializer = new RecordXMLSerializer<T>(recordClass, customFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T queryById(long id, Transaction<?> transaction) throws DatasetException {
        Map<Long, T> map = this.records;
        synchronized (map) {
            if (!this.records.containsKey(id)) {
                this.refreshById(id, transaction);
            }
            return (T)((Commitable)this.records.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getRecordById(long id) {
        Map<Long, T> map = this.records;
        synchronized (map) {
            return (T)((Commitable)this.records.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getRecord(int index) {
        Map<Long, T> map = this.records;
        synchronized (map) {
            return (T)(index >= 0 && index < this.recordIds.size() ? (Commitable)this.records.get(this.recordIds.get(index)) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map<Long, T> map = this.records;
        synchronized (map) {
            return this.records.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> queryAll(Transaction<?> transaction) throws DatasetException {
        Map<Long, T> map = this.records;
        synchronized (map) {
            return new ArrayList<T>(this.records.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordCount(Transaction<?> transaction) throws DatasetException {
        Map<Long, T> map = this.records;
        synchronized (map) {
            return this.records.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalPages() {
        Map<Long, T> map = this.records;
        synchronized (map) {
            return this.totalPages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalRecords() {
        Map<Long, T> map = this.records;
        synchronized (map) {
            return this.totalRecords;
        }
    }

    @Override
    public void refresh(T record, Transaction<?> transaction) throws DatasetException {
        this.refreshById(record.getId(), transaction);
    }

    @Override
    public Abortable reload(final Transaction<?> transaction) throws DatasetException {
        this.clear(transaction);
        HttpGet request = new HttpGet(this.getReloadUrl());
        Abortable abortable = this.httpServiceClient.executeRequestAsync((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void handleResponse(HttpResponse response) throws Exception {
                InputStream inputStream = response.getEntity().getContent();
                QueryResult queryResult = WebserviceDataset.this.recordSerializer.parsePagedXML(inputStream);
                List receivedRecords = queryResult.getRecords();
                Map map = WebserviceDataset.this.records;
                synchronized (map) {
                    for (Commitable record : receivedRecords) {
                        WebserviceDataset.this.records.put(record.getId(), record);
                        WebserviceDataset.this.recordIds.add(record.getId());
                    }
                    WebserviceDataset.this.totalPages = queryResult.getTotalPages();
                    WebserviceDataset.this.totalRecords = queryResult.getTotalRecords();
                    WebserviceDataset.this.currentPage = queryResult.getPage();
                }
                WebserviceDataset.this.notifyRecordsModified(receivedRecords, transaction);
                WebserviceDataset.this.notifyReloadFinished();
                return null;
            }
        }, new RequestFailedHandler(){

            public void requestFailed(Exception exception) {
                WebserviceDataset.this.notifyRecordsModified(new ArrayList(0), transaction);
                WebserviceDataset.this.notifyReloadFailed();
            }

            public void requestAborted() {
                WebserviceDataset.this.notifyRecordsModified(new ArrayList(0), transaction);
                WebserviceDataset.this.notifyReloadAborted();
            }
        });
        this.notifyReloadInitialized(abortable);
        return abortable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(Transaction<?> transaction) {
        Map<Long, T> map = this.records;
        synchronized (map) {
            this.records.clear();
            this.recordIds.clear();
            this.totalRecords = 0;
            this.totalPages = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<Long, T> map = this.records;
        synchronized (map) {
            this.records.clear();
            this.recordIds.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordsModified(Collection<T> modifiedRecords, Transaction<?> transaction) {
        Map<Long, T> map = this.records;
        synchronized (map) {
            for (Commitable record : modifiedRecords) {
                CommitState commitState = record.getCommitState();
                if (commitState == null || record.getId() == null) continue;
                if (commitState.isInserted()) {
                    this.records.put(record.getId(), record);
                    this.recordIds.add(record.getId());
                    continue;
                }
                if (commitState.isUpdated()) {
                    this.records.put(record.getId(), record);
                    continue;
                }
                if (!commitState.isDeleted()) continue;
                this.records.remove(record.getId());
                this.recordIds.remove(record.getId());
            }
        }
        this.notifyRecordsModified(modifiedRecords, transaction);
    }

    private void refreshById(Long id, final Transaction<?> transaction) throws DatasetException {
        try {
            HttpGet request = new HttpGet(this.getQueryByIdUrl(id));
            this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void handleResponse(HttpResponse response) throws Exception {
                    InputStream inputStream = response.getEntity().getContent();
                    List receivedRecords = WebserviceDataset.this.recordSerializer.parseXML(inputStream);
                    if (receivedRecords.size() != 1) {
                        throw new DatasetException("Unexpected result size for single row query", new Object[0]);
                    }
                    Commitable record = (Commitable)new ArrayList(receivedRecords).get(0);
                    Map map = WebserviceDataset.this.records;
                    synchronized (map) {
                        if (!WebserviceDataset.this.records.containsKey(record.getId())) {
                            WebserviceDataset.this.recordIds.add(record.getId());
                        }
                        WebserviceDataset.this.records.put(record.getId(), record);
                    }
                    WebserviceDataset.this.notifyRecordsModified(receivedRecords, transaction);
                    return null;
                }
            });
        }
        catch (WebserviceException exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    protected String getReloadUrl() {
        return this.getServiceUrl() + "/index.xml" + this.getQueryParameters();
    }

    protected String getQueryByIdUrl(long id) {
        return String.format(this.getServiceUrl() + "/%d.xml", id);
    }

    protected String getServiceUrl() {
        return "/service/" + this.getRecordClass().getSimpleName().toLowerCase();
    }

    protected String getQueryParameters() {
        if (this.recordsPerPage == RecordsPerPage.ALL_RECORDS) {
            return "";
        }
        if (this.recordsPerPage == RecordsPerPage.SYSTEM_DEFAULT) {
            return "?page=" + this.currentPage;
        }
        return "?page=" + this.currentPage + "&recordsPerPage=" + this.recordsPerPage.getRecordCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageCount() {
        Map<Long, T> map = this.records;
        synchronized (map) {
            return this.totalPages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentPage() {
        Map<Long, T> map = this.records;
        synchronized (map) {
            return this.currentPage;
        }
    }

    public void selectNextPage(Transaction<?> transaction) throws DatasetException {
        if (this.currentPage < this.totalPages - 1) {
            ++this.currentPage;
            this.reload(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPreviousPage(Transaction<?> transaction) throws DatasetException {
        Map<Long, T> map = this.records;
        synchronized (map) {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.reload(transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFirstPage(Transaction<?> transaction) throws DatasetException {
        Map<Long, T> map = this.records;
        synchronized (map) {
            if (this.currentPage != 0) {
                this.currentPage = 0;
                this.reload(transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectLastPage(Transaction<?> transaction) throws DatasetException {
        Map<Long, T> map = this.records;
        synchronized (map) {
            if (this.currentPage != this.totalPages - 1) {
                this.currentPage = this.totalPages - 1;
                this.reload(transaction);
            }
        }
    }

    public void selectPage(int pageIndex, Transaction<?> transaction) throws DatasetException {
        this.abortableSelectPage(pageIndex, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Abortable abortableSelectPage(int pageIndex, Transaction<?> transaction) throws DatasetException {
        Map<Long, T> map = this.records;
        synchronized (map) {
            if (pageIndex < 0 || pageIndex > this.totalPages - 1) {
                throw new IllegalArgumentException("Illegal page index " + pageIndex);
            }
            if (this.currentPage != pageIndex) {
                this.currentPage = pageIndex;
                return this.reload(transaction);
            }
        }
        return Abortable.DO_NOTHING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsPerPage getRecordsPerPage() {
        Map<Long, T> map = this.records;
        synchronized (map) {
            return this.recordsPerPage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecordsPerPage(RecordsPerPage recordsPerPage, Transaction<?> transaction) throws DatasetException {
        Map<Long, T> map = this.records;
        synchronized (map) {
            if (this.recordsPerPage != recordsPerPage) {
                this.recordsPerPage = recordsPerPage;
                this.currentPage = 0;
                this.reload(transaction);
            }
        }
    }
}

