/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence;

import at.mrdevelopment.esl.persistence.RecordSerializer;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.type.TypeFactory;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecordXMLSerializer<T>
extends RecordSerializer<T> {
    static ESLLogger logger = ESLLogger.getLogger(RecordXMLSerializer.class);
    private final XMLToolkit xmlToolkit;
    private final Class<T> recordClass;
    private final boolean singleRecord;
    private final Map<Class<?>, Map<String, RecordSerializer.GetSetField>> fields = new HashMap();

    public RecordXMLSerializer(Class<T> recordClass) throws InitializationException {
        this(recordClass, false, null);
    }

    public RecordXMLSerializer(Class<T> recordClass, List<String> customFields) throws InitializationException {
        this(recordClass, false, customFields);
    }

    public RecordXMLSerializer(Class<T> recordClass, boolean singleRecord, List<String> customFields) throws InitializationException {
        this.recordClass = recordClass;
        this.singleRecord = singleRecord;
        this.xmlToolkit = new XMLToolkit();
        Map<String, RecordSerializer.GetSetField> recordClassFields = this.getFields(recordClass, customFields);
        this.fields.put(recordClass, recordClassFields);
        for (RecordSerializer.GetSetField field : recordClassFields.values()) {
            if (!field.isRecursive()) continue;
            Map<String, RecordSerializer.GetSetField> recursiveFields = this.getFields(field.getType(), customFields);
            this.fields.put(field.getType(), recursiveFields);
        }
    }

    public List<T> parseXML(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        if (root.getNodeName().equals("PagedResult")) {
            NodeList nodes = root.getChildNodes();
            for (int index = 0; index < nodes.getLength(); ++index) {
                if (!(nodes.item(index) instanceof Element)) continue;
                return this.parseRecords((Element)nodes.item(index));
            }
        }
        return this.parseRecords(root);
    }

    public QueryResult<T> parsePagedXML(InputStream inputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        if (root.getNodeName().equals("PagedResult")) {
            int page = Integer.parseInt(root.getAttribute("page"));
            int recordsPerPage = Integer.parseInt(root.getAttribute("recordsPerPage"));
            int totalRecords = Integer.parseInt(root.getAttribute("totalRecords"));
            List<T> records = null;
            NodeList nodes = root.getChildNodes();
            for (int index = 0; index < nodes.getLength(); ++index) {
                if (!(nodes.item(index) instanceof Element)) continue;
                records = this.parseRecords((Element)nodes.item(index));
            }
            return QueryResult.newPagedResult(records, (int)totalRecords, (int)page, (int)recordsPerPage);
        }
        return QueryResult.newUnpagedResult(this.parseRecords(root));
    }

    public Document toXML(T record) throws SerializeException {
        return this.toXML((Collection<T>)Collections.singleton(record));
    }

    public Document toXML(int count) throws SerializeException {
        Document document = this.xmlToolkit.newDocument();
        Element element = document.createElement(this.recordClass.getSimpleName() + (this.singleRecord ? "Entry" : "List"));
        element.setAttribute("count", Integer.toString(count));
        document.appendChild(element);
        return document;
    }

    public Document toXML(QueryResult<T> queryResult) throws SerializeException {
        if (queryResult.isPagedResults()) {
            Document document = this.xmlToolkit.newDocument();
            Element pagedResult = document.createElement("PagedResult");
            pagedResult.setAttribute("records", Integer.toString(queryResult.getRecords().size()));
            pagedResult.setAttribute("totalRecords", Integer.toString(queryResult.getTotalRecords()));
            pagedResult.setAttribute("page", Integer.toString(queryResult.getPage()));
            pagedResult.setAttribute("totalPages", Integer.toString(queryResult.getTotalPages()));
            pagedResult.setAttribute("recordsPerPage", Integer.toString(queryResult.getRecordsPerPage()));
            document.appendChild(pagedResult);
            Element list = this.recordsToXML(document, queryResult.getRecords());
            pagedResult.appendChild(list);
            return document;
        }
        return this.toXML(queryResult.getRecords());
    }

    public Document toXML(Collection<T> records) throws SerializeException {
        Document document = this.xmlToolkit.newDocument();
        Element list = this.recordsToXML(document, records);
        document.appendChild(list);
        return document;
    }

    private Element recordsToXML(Document document, Collection<T> records) throws SerializeException {
        Element list = document.createElement(this.recordClass.getSimpleName() + (this.singleRecord ? "Entry" : "List"));
        list.setAttribute("count", Integer.toString(records.size()));
        for (T record : records) {
            list.appendChild(this.recordToXML(document, record));
        }
        return list;
    }

    private Element recordToXML(Document document, Object record) throws SerializeException {
        try {
            Element recordElement = document.createElement(record.getClass().getSimpleName());
            for (RecordSerializer.GetSetField field : this.fields.get(record.getClass()).values()) {
                Method method = field.getGetMethod();
                Object value = null;
                value = field.hasKey() ? method.invoke(record, field.getKey()) : method.invoke(record, new Object[0]);
                if (value == null) continue;
                if (field.isRecursive()) {
                    Element childElement = this.recordToXML(document, value);
                    recordElement.appendChild(childElement);
                    continue;
                }
                Element fieldElement = document.createElement(field.getName());
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    for (Object item : collection) {
                        Element itemElement = document.createElement("Item");
                        itemElement.setTextContent(TypeFactory.toString(item));
                        fieldElement.appendChild(itemElement);
                    }
                } else {
                    fieldElement.setTextContent(TypeFactory.toString(value));
                }
                recordElement.appendChild(fieldElement);
            }
            return recordElement;
        }
        catch (SecurityException exc) {
            throw new SerializeException((Throwable)exc);
        }
        catch (IllegalArgumentException exc) {
            throw new SerializeException((Throwable)exc);
        }
        catch (IllegalAccessException exc) {
            throw new SerializeException((Throwable)exc);
        }
        catch (InvocationTargetException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private List<T> parseRecords(Element root) throws SerializeException {
        NodeList recordNodes = root.getChildNodes();
        ArrayList<T> records = new ArrayList<T>(recordNodes.getLength());
        for (int index = 0; index < recordNodes.getLength(); ++index) {
            Node node = recordNodes.item(index);
            if (!(node instanceof Element)) continue;
            Element recordElement = (Element)recordNodes.item(index);
            Object record = this.parseRecord(this.recordClass, recordElement);
            records.add(this.recordClass.cast(record));
        }
        return records;
    }

    private Object parseRecord(Class<?> type, Element recordElement) throws SerializeException {
        try {
            Object record = type.newInstance();
            NodeList nodeList = recordElement.getChildNodes();
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Method method;
                Node node = nodeList.item(index);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                String fieldName = element.getTagName();
                RecordSerializer.GetSetField field = this.fields.get(type).get(fieldName);
                if (field == null) continue;
                if (field.isRecursive()) {
                    Class<?> childType = field.getType();
                    Object child = this.parseRecord(childType, element);
                    if (!field.isWriteable()) continue;
                    method = field.getSetMethod();
                    method.invoke(record, child);
                    continue;
                }
                Class<?> fieldType = field.getType();
                HashSet value = null;
                if (fieldType == Set.class) {
                    HashSet set = new HashSet();
                    NodeList itemNodeList = element.getElementsByTagName("Item");
                    for (int itemIndex = 0; itemIndex < itemNodeList.getLength(); ++itemIndex) {
                        Element item = (Element)itemNodeList.item(itemIndex);
                        String valueString = item.getTextContent();
                        Object itemValue = TypeFactory.valueOf(field.getCollectionType(), valueString);
                        set.add(itemValue);
                    }
                    value = set;
                } else {
                    String valueString = element.getTextContent();
                    value = (HashSet)TypeFactory.valueOf(fieldType, valueString, type);
                }
                if (!field.isWriteable()) continue;
                method = field.getSetMethod();
                if (field.hasKey()) {
                    method.invoke(record, field.getKey(), value);
                    continue;
                }
                method.invoke(record, value);
            }
            return record;
        }
        catch (SerializeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }
}

