/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence;

import at.mrdevelopment.esl.persistence.annotation.CustomField;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.toolkit.InitializationException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public abstract class RecordSerializer<T> {
    protected Map<String, GetSetField> getFields(Class<?> recordClass, List<String> customFields) throws InitializationException {
        TreeMap<String, GetSetField> fields = new TreeMap<String, GetSetField>();
        for (Method method : recordClass.getMethods()) {
            Serialize serializeAnnotation = method.getAnnotation(Serialize.class);
            CustomField customFieldAnnotation = method.getAnnotation(CustomField.class);
            if (serializeAnnotation == null || !method.getName().startsWith("get")) continue;
            String name = method.getName().substring(3);
            Class<?> type = method.getReturnType();
            Class collectionType = serializeAnnotation.collectionType();
            Method setMethod = null;
            boolean recursive = serializeAnnotation.recursive();
            boolean archive = serializeAnnotation.archive();
            if (customFieldAnnotation != null) {
                for (String customFieldKey : customFields) {
                    String customFieldName = String.format("%s.%s", name, StringUtils.capitalize((String)customFieldKey));
                    try {
                        setMethod = recordClass.getMethod("set" + name, String.class, type);
                    }
                    catch (NoSuchMethodException ignore) {
                        // empty catch block
                    }
                    GetSetField field = new GetSetField(customFieldName, type, collectionType, method, setMethod, recursive, customFieldKey, archive);
                    fields.put(customFieldName, field);
                }
                continue;
            }
            try {
                setMethod = recordClass.getMethod("set" + name, type);
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
            GetSetField field = new GetSetField(name, type, collectionType, method, setMethod, recursive, null, archive);
            fields.put(name, field);
        }
        return fields;
    }

    public static class GetSetField {
        private final String name;
        private final Class<?> type;
        private final Class<?> collectionType;
        private final Method getMethod;
        private final Method setMethod;
        private final boolean recursive;
        private final String key;
        private final boolean archive;

        public GetSetField(String name, Class<?> type, Class<?> collectionType, Method getMethod, Method setMethod, boolean recursive, String key, boolean archive) {
            this.name = name;
            this.type = type;
            this.collectionType = collectionType;
            this.getMethod = getMethod;
            this.setMethod = setMethod;
            this.recursive = recursive;
            this.key = key;
            this.archive = archive;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Class<?> getCollectionType() {
            return this.collectionType;
        }

        public Method getGetMethod() {
            return this.getMethod;
        }

        public Method getSetMethod() {
            return this.setMethod;
        }

        public boolean isReadable() {
            return this.getMethod != null;
        }

        public boolean isWriteable() {
            return this.setMethod != null;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public boolean hasKey() {
            return this.key != null;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isArchive() {
            return this.archive;
        }
    }
}

