/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence;

import at.mrdevelopment.esl.persistence.RecordSerializer;
import at.mrdevelopment.esl.type.TypeFactory;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecordCsvSerializer<T>
extends RecordSerializer<T> {
    static ESLLogger logger = ESLLogger.getLogger(RecordCsvSerializer.class);
    private final Class<T> recordClass;
    private final boolean singleRecord;
    private final Map<Class<?>, Map<String, RecordSerializer.GetSetField>> fields = new HashMap();

    public RecordCsvSerializer(Class<T> recordClass) throws InitializationException {
        this(recordClass, false, null);
    }

    public RecordCsvSerializer(Class<T> recordClass, boolean singleRecord, List<String> customFields) throws InitializationException {
        this.recordClass = recordClass;
        this.singleRecord = singleRecord;
        Map<String, RecordSerializer.GetSetField> recordClassFields = this.getFields(recordClass, customFields);
        this.fields.put(recordClass, recordClassFields);
        for (RecordSerializer.GetSetField field : recordClassFields.values()) {
            if (!field.isRecursive()) continue;
            Map<String, RecordSerializer.GetSetField> recursiveFields = this.getFields(field.getType(), customFields);
            this.fields.put(field.getType(), recursiveFields);
        }
    }

    public List<List<String>> toArchiveCsv(Collection<T> records, boolean appendHeader) throws SerializeException {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        if (records != null && !records.isEmpty()) {
            if (appendHeader) {
                list.add(this.getCsvHeader(records.iterator().next(), this.recordClass.getSimpleName() + (this.singleRecord ? "Entry" : "List")));
            }
            for (T record : records) {
                list.add(this.recordToCsv(record));
            }
        }
        return list;
    }

    private List<String> recordToCsv(Object record) throws SerializeException {
        ArrayList<String> recordList = new ArrayList<String>();
        try {
            for (RecordSerializer.GetSetField field : this.fields.get(record.getClass()).values()) {
                if (!field.isArchive()) continue;
                Method method = field.getGetMethod();
                Object value = null;
                value = field.hasKey() ? method.invoke(record, field.getKey()) : method.invoke(record, new Object[0]);
                if (value != null) {
                    if (field.isRecursive()) {
                        List<String> childElement = this.recordToCsv(value);
                        recordList.addAll(childElement);
                        continue;
                    }
                    if (value instanceof Collection) {
                        Collection collection = (Collection)value;
                        recordList.add(this.getCollectionCsv(collection, ","));
                        continue;
                    }
                    recordList.add(TypeFactory.toString(value));
                    continue;
                }
                recordList.add(TypeFactory.toString(""));
            }
        }
        catch (IllegalArgumentException exception) {
            throw new SerializeException((Throwable)exception);
        }
        catch (IllegalAccessException exception) {
            throw new SerializeException((Throwable)exception);
        }
        catch (InvocationTargetException exception) {
            throw new SerializeException((Throwable)exception);
        }
        return recordList;
    }

    private List<String> getCsvHeader(Object record, String baseHeader) throws SerializeException {
        ArrayList<String> headerList = new ArrayList<String>();
        try {
            for (RecordSerializer.GetSetField field : this.fields.get(record.getClass()).values()) {
                if (!field.isArchive()) continue;
                Method method = field.getGetMethod();
                Object value = null;
                value = field.hasKey() ? method.invoke(record, field.getKey()) : method.invoke(record, new Object[0]);
                if (value != null) {
                    if (field.isRecursive()) {
                        List<String> childElement = this.getCsvHeader(value, this.appendHeaderField(baseHeader, record.getClass().getSimpleName()));
                        headerList.addAll(childElement);
                        continue;
                    }
                    headerList.add(this.appendHeaderField(baseHeader, this.getHeaderField(record, field)));
                    continue;
                }
                headerList.add(this.appendHeaderField(baseHeader, this.getHeaderField(record, field)));
            }
        }
        catch (IllegalArgumentException exception) {
            throw new SerializeException((Throwable)exception);
        }
        catch (IllegalAccessException exception) {
            throw new SerializeException((Throwable)exception);
        }
        catch (InvocationTargetException exception) {
            throw new SerializeException((Throwable)exception);
        }
        return headerList;
    }

    private String getHeaderField(Object record, RecordSerializer.GetSetField field) {
        return this.appendHeaderField(record.getClass().getSimpleName(), field.getName());
    }

    private String appendHeaderField(String baseHeader, String headerField) {
        return String.format("%s:%s", baseHeader, headerField);
    }

    private String getCollectionCsv(Collection<Object> collection, String delimiter) {
        StringBuilder builder = new StringBuilder();
        for (Object item : collection) {
            builder.append(TypeFactory.toString(item));
            builder.append(delimiter);
        }
        String collectionCsv = builder.toString();
        if (collectionCsv.endsWith(delimiter)) {
            collectionCsv = collectionCsv.substring(0, collectionCsv.lastIndexOf(delimiter));
        }
        return collectionCsv;
    }
}

