/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licensing.gui;

import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;

public class RangeListModel
extends AbstractListModel {
    private final List<Range<Address>> ranges = new ArrayList<Range<Address>>();
    private final List<Integer> counts = new ArrayList<Integer>();

    public void addLabelRange(Range<Address> labelRange) {
        int newIndex = this.ranges.size();
        this.ranges.add(labelRange);
        this.counts.add(labelRange.getCount());
        this.fireIntervalAdded(this, newIndex, newIndex);
    }

    @Override
    public int getSize() {
        return this.ranges.size();
    }

    @Override
    public RangeEntry getElementAt(int index) {
        return new RangeEntry(this.ranges.get(index), this.counts.get(index));
    }

    public List<Range<Address>> getRanges() {
        return Collections.unmodifiableList(this.ranges);
    }

    public void clear() {
        if (!this.ranges.isEmpty()) {
            int lastIndex = this.ranges.size() - 1;
            this.ranges.clear();
            this.counts.clear();
            this.fireIntervalRemoved(this, 0, lastIndex);
        }
    }

    public void removeElement(int index) {
        this.ranges.remove(index);
        this.counts.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public int getRangesCount() {
        return this.ranges.size();
    }

    public int getTotalLabelsCount() {
        int totalCount = 0;
        for (int count : this.counts) {
            totalCount += count;
        }
        return totalCount;
    }

    public static class RangeEntry {
        private final Range<Address> range;
        private final int count;

        public RangeEntry(Range<Address> range, int count) {
            this.range = range;
            this.count = count;
        }

        public Range<Address> getRange() {
            return this.range;
        }

        public int getCount() {
            return this.count;
        }
    }
}

