/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licensing.gui;

import at.mrdevelopment.esl.gui.editor.LabelIdEditor;
import at.mrdevelopment.esl.licencing.LabelRangeImport;
import at.mrdevelopment.esl.licensing.gui.RangeListModel;
import at.mrdevelopment.esl.type.LicenceContent;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.Range;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import at.mrdevelopment.toolkit.gui.SpringUtilities;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.TransferHandler;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class LabelsTab {
    static ESLLogger logger = ESLLogger.getLogger(LabelsTab.class);
    private final JPanel mainPanel;
    private final LabelIdEditor startLabelIdEditor = new LabelIdEditor(false);
    private final LabelIdEditor endLabelIdEditor = new LabelIdEditor(true);
    private final RangeListModel rangesModel = new RangeListModel();
    private JList rangesList;
    private JButton optimizeButton;
    private JButton removeButton;
    private JPanel listPanel;

    public LabelsTab() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.getFormComponent(), "North");
        this.mainPanel.add((Component)this.getContentComponent(), "Center");
        this.mainPanel.add((Component)this.getButtonsComponent(), "South");
    }

    private JComponent getFormComponent() {
        KeyAdapter addLabelRangeOnEnterListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    LabelsTab.this.onAddLabelRange();
                }
            }
        };
        this.startLabelIdEditor.getEditorComponent().addKeyListener(addLabelRangeOnEnterListener);
        this.endLabelIdEditor.getEditorComponent().addKeyListener(addLabelRangeOnEnterListener);
        JButton addButton = new JButton("Add");
        addButton.setMnemonic(65);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LabelsTab.this.onAddLabelRange();
            }
        });
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LabelsTab.this.onClearForm();
            }
        });
        JPanel formPanel = new JPanel(new SpringLayout());
        formPanel.add(new JLabel("First label ID:", 11));
        formPanel.add(this.startLabelIdEditor.getEditorComponent());
        formPanel.add(new JLabel("Last label ID:", 11));
        formPanel.add(this.endLabelIdEditor.getEditorComponent());
        JPanel formButtonPanel = new JPanel(new FlowLayout());
        formButtonPanel.add(addButton);
        formButtonPanel.add(clearButton);
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.setBorder(GUIUtils.createBorder((String)"Add label range"));
        inputPanel.add((Component)formPanel, "North");
        inputPanel.add((Component)formButtonPanel, "South");
        SpringUtilities.makeCompactGrid((Container)formPanel, (int)2, (int)2, (int)8, (int)2, (int)4, (int)4);
        return inputPanel;
    }

    private JComponent getContentComponent() {
        this.rangesList = new JList(this.rangesModel);
        this.rangesList.getInputMap().put(KeyStroke.getKeyStroke("ctrl v"), TransferHandler.getPasteAction().getValue("Name"));
        this.rangesList.getActionMap().put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        this.rangesList.setTransferHandler(new ListTransferHandler());
        this.rangesList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                RangeListModel.RangeEntry rangeEntry = (RangeListModel.RangeEntry)value;
                int count = rangeEntry.getCount();
                String rangeString = rangeEntry.getRange().getRangeString();
                if (count == 1) {
                    this.setText(rangeString);
                } else {
                    this.setText(String.format("%s (%d labels)", rangeString, count));
                }
                return this;
            }
        });
        this.rangesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                LabelsTab.this.onSelectionUpdated();
            }
        });
        this.rangesModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent event) {
                LabelsTab.this.onLabelRangesChanged();
            }

            @Override
            public void intervalAdded(ListDataEvent event) {
                LabelsTab.this.onLabelRangesChanged();
            }

            @Override
            public void contentsChanged(ListDataEvent event) {
                LabelsTab.this.onLabelRangesChanged();
            }
        });
        this.listPanel = new JPanel(new SpringLayout());
        this.listPanel.add(new JScrollPane(this.rangesList));
        this.listPanel.setBorder(GUIUtils.createBorder((String)"Label ranges"));
        SpringUtilities.makeCompactGrid((Container)this.listPanel, (int)1, (int)1, (int)4, (int)0, (int)4, (int)4);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)this.listPanel, "Center");
        return contentPanel;
    }

    private JComponent getButtonsComponent() {
        JButton importButton = new JButton("Import labels");
        importButton.setMnemonic(73);
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LabelsTab.this.onImportLabelRanges();
            }
        });
        this.optimizeButton = new JButton("Optimize");
        this.optimizeButton.setMnemonic(79);
        this.optimizeButton.setEnabled(false);
        this.optimizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LabelsTab.this.onOptimizeLabelRanges();
            }
        });
        this.removeButton = new JButton("Remove");
        this.removeButton.setMnemonic(82);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LabelsTab.this.onRemoveLabelRanges();
            }
        });
        JButton clearButton = new JButton("Clear");
        clearButton.setMnemonic(67);
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LabelsTab.this.onClearLabelRanges();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(importButton);
        buttonPanel.add(this.optimizeButton);
        buttonPanel.add(this.removeButton);
        buttonPanel.add(clearButton);
        return buttonPanel;
    }

    public JComponent getMainPanel() {
        return this.mainPanel;
    }

    public List<Range<Address>> getLabelRanges() {
        return this.rangesModel.getRanges();
    }

    public void clearRanges() {
        this.rangesModel.clear();
    }

    private void validateEditors() {
        this.startLabelIdEditor.validate();
        this.endLabelIdEditor.validate();
        if (!this.startLabelIdEditor.hasErrors() && !this.endLabelIdEditor.hasErrors()) {
            Long startLabelId = this.startLabelIdEditor.getValue();
            Long endLabelId = this.endLabelIdEditor.getValue();
            Address startAddress = Address.fromId((long)startLabelId);
            if (endLabelId != null) {
                Address endAddress = Address.fromId((long)endLabelId);
                if (startAddress.getTypeIdentifier() != endAddress.getTypeIdentifier()) {
                    this.endLabelIdEditor.addError("Must be of same label type range");
                }
                if (endAddress.compareTo(startAddress) < 0) {
                    this.endLabelIdEditor.addError("Must not be lower than the first label ID");
                }
            }
        }
    }

    private void onLabelRangesChanged() {
        int rangesCount = this.rangesModel.getRangesCount();
        int labelsCount = this.rangesModel.getTotalLabelsCount();
        this.listPanel.setBorder(GUIUtils.createBorder((String)String.format("%d Label ranges (%s total labels)", rangesCount, labelsCount)));
        this.optimizeButton.setEnabled(true);
    }

    private void onSelectionUpdated() {
        boolean hasSelection = this.rangesList.getSelectedIndex() != -1;
        this.removeButton.setEnabled(hasSelection);
    }

    private void onAddLabelRange() {
        try {
            this.validateEditors();
            if (!this.startLabelIdEditor.hasErrors() && !this.endLabelIdEditor.hasErrors()) {
                Long startLabelId = this.startLabelIdEditor.getValue();
                Long endLabelId = this.endLabelIdEditor.getValue();
                Address startAddress = Address.fromId((long)startLabelId);
                if (endLabelId != null) {
                    Address endAddress = Address.fromId((long)endLabelId);
                    Range labelRange = new Range((Comparable)startAddress, (Comparable)endAddress);
                    this.rangesModel.addLabelRange((Range<Address>)labelRange);
                } else {
                    Range singleLabel = new Range((Comparable)startAddress, (Comparable)startAddress);
                    this.rangesModel.addLabelRange((Range<Address>)singleLabel);
                }
                this.startLabelIdEditor.clear();
                this.endLabelIdEditor.clear();
                this.startLabelIdEditor.getEditorComponent().requestFocusInWindow();
            }
        }
        catch (Exception exc) {
            logger.logException((Throwable)exc);
        }
    }

    private void onClearForm() {
        try {
            this.startLabelIdEditor.clear();
            this.endLabelIdEditor.clear();
        }
        catch (Exception exc) {
            logger.logException((Throwable)exc);
        }
    }

    private void onImportLabelRanges() {
        try {
            LabelRangeImport labelImport = new LabelRangeImport();
            JFileChooser fileChooser = new JFileChooser("data");
            fileChooser.setFileSelectionMode(0);
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setFileFilter(new FileNameExtensionFilter("Label files (*.csv)", "csv"));
            int result = fileChooser.showOpenDialog(null);
            if (result == 0) {
                File[] labelFiles;
                for (File labelFile : labelFiles = fileChooser.getSelectedFiles()) {
                    List labelRanges = labelImport.readLabelRangesFromFile(labelFile);
                    for (Range labelRange : labelRanges) {
                        this.rangesModel.addLabelRange((Range<Address>)labelRange);
                    }
                }
            }
        }
        catch (Exception exc) {
            logger.logException((Throwable)exc);
        }
    }

    private void onOptimizeLabelRanges() {
        try {
            if (this.rangesModel.getRanges().size() > 1) {
                LicenceContent licenceContent = new LicenceContent(this.rangesModel.getRanges(), new HashSet());
                List optimizedRanges = licenceContent.getOptimizedRanges();
                this.rangesModel.clear();
                for (Range labelRange : optimizedRanges) {
                    this.rangesModel.addLabelRange((Range<Address>)labelRange);
                }
            }
            this.optimizeButton.setEnabled(false);
        }
        catch (Exception exc) {
            logger.logException((Throwable)exc);
        }
    }

    private void onRemoveLabelRanges() {
        try {
            int[] selectedIndices = this.rangesList.getSelectedIndices();
            for (int iterationIndex = selectedIndices.length - 1; iterationIndex >= 0; --iterationIndex) {
                int indexInList = selectedIndices[iterationIndex];
                this.rangesModel.removeElement(indexInList);
            }
        }
        catch (Exception exc) {
            logger.logException((Throwable)exc);
        }
    }

    private void onClearLabelRanges() {
        try {
            this.rangesModel.clear();
        }
        catch (Exception exc) {
            logger.logException((Throwable)exc);
        }
    }

    private class ListTransferHandler
    extends TransferHandler {
        private ListTransferHandler() {
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            if (info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String[] splitted;
                    String data = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    for (String labelString : splitted = data.split("[\r\n]+")) {
                        try {
                            Address address = Address.fromString((String)labelString);
                            Range singleLabel = new Range((Comparable)address, (Comparable)address);
                            LabelsTab.this.rangesModel.addLabelRange((Range<Address>)singleLabel);
                        }
                        catch (NumberFormatException exc) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

