/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licensing;

import at.mrdevelopment.esl.licencing.LicenceXMLSerializer;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.LicenceRecord;
import at.mrdevelopment.esl.type.Licence;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.comparator.NameFileComparator;

public class LicenseImport {
    private final Dataset<LicenceRecord> licenseDataset;
    private final LicenceXMLSerializer licenceSerializer;

    public LicenseImport(Dataset<LicenceRecord> licenseDataset) throws InitializationException {
        this.licenseDataset = licenseDataset;
        this.licenceSerializer = new LicenceXMLSerializer();
    }

    public void importLicenses(File licenseImportDirectory, Transaction<?> transaction) throws Exception {
        if (!licenseImportDirectory.exists() || !licenseImportDirectory.isDirectory()) {
            return;
        }
        this.importLicenses(licenseImportDirectory.listFiles(), transaction);
    }

    public void importLicenses(File[] licenseFiles, Transaction<?> transaction) throws Exception {
        if (licenseFiles != null) {
            Arrays.sort(licenseFiles, NameFileComparator.NAME_COMPARATOR);
            for (File licenseFile : licenseFiles) {
                if (!licenseFile.exists() || !licenseFile.isFile() || !FilenameUtils.isExtension((String)licenseFile.getPath(), (String)"licence") && !FilenameUtils.isExtension((String)licenseFile.getPath(), (String)"license")) continue;
                this.importLicense(licenseFile, transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importLicense(File licenseFile, Transaction<?> transaction) throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(licenseFile);
            Licence licence = null;
            try {
                licence = this.licenceSerializer.parseXML(inputStream);
            }
            catch (SerializeException exception) {
                inputStream.close();
                return;
            }
            List licenceRecords = this.licenseDataset.queryAll(transaction);
            for (LicenceRecord licenceRecord : licenceRecords) {
                if (!licence.getLicenceKey().equals(licenceRecord.getLicenceKey())) continue;
                return;
            }
            LicenceRecord record = LicenceRecord.fromLicence(licence);
            this.licenseDataset.store(Collections.singleton(record), UserId.SYSTEM, transaction);
        }
        finally {
            inputStream.close();
        }
    }
}

