/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.labelstatistics;

import at.mrdevelopment.esl.labelstatistics.LabelStatistics;
import at.mrdevelopment.esl.labelstatistics.StatisticCategory;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.toolkit.Range;

public class RssiLabelInfo
extends LabelStatistics {
    private final Range<Integer> rssiRange;

    public RssiLabelInfo(StatisticCategory statisticCategory, Range<Integer> rssiRange, int totalLabels) {
        super(statisticCategory, totalLabels);
        this.rssiRange = rssiRange;
    }

    @Override
    public void process(LabelInfo labelInfo) {
        if (this.rssiRange == null) {
            if (labelInfo.getRssi() == null) {
                ++this.count;
            }
        } else if (labelInfo.getRssi() != null && this.rssiRange.contains((Comparable)labelInfo.getRssi())) {
            ++this.count;
        }
    }

    @Override
    public String getIdentifier() {
        String identifier = RSSI.UNKNOWN.getIdentifier();
        if (this.rssiRange != null) {
            identifier = (Integer)this.rssiRange.getFrom() == -70 ? RSSI.CLASS_A.getIdentifier() : ((Integer)this.rssiRange.getFrom() == -75 && (Integer)this.rssiRange.getTo() == -71 ? RSSI.CLASS_B.getIdentifier() : ((Integer)this.rssiRange.getFrom() == -80 && (Integer)this.rssiRange.getTo() == -76 ? RSSI.CLASS_C.getIdentifier() : ((Integer)this.rssiRange.getFrom() == -85 && (Integer)this.rssiRange.getTo() == -81 ? RSSI.CLASS_D.getIdentifier() : ((Integer)this.rssiRange.getFrom() == -90 && (Integer)this.rssiRange.getTo() == -86 ? RSSI.CLASS_E.getIdentifier() : ((Integer)this.rssiRange.getFrom() == -92 && (Integer)this.rssiRange.getTo() == -91 ? RSSI.CLASS_F.getIdentifier() : RSSI.CLASS_G.getIdentifier())))));
        }
        return String.format("%s", identifier);
    }

    @Override
    public String getDescription() {
        String description = RSSI.UNKNOWN.getDescription();
        if (this.rssiRange != null) {
            description = (Integer)this.rssiRange.getFrom() == -70 ? RSSI.CLASS_A.getDescription() : ((Integer)this.rssiRange.getFrom() == -75 && (Integer)this.rssiRange.getTo() == -71 ? RSSI.CLASS_B.getDescription() : ((Integer)this.rssiRange.getFrom() == -80 && (Integer)this.rssiRange.getTo() == -76 ? RSSI.CLASS_C.getDescription() : ((Integer)this.rssiRange.getFrom() == -85 && (Integer)this.rssiRange.getTo() == -81 ? RSSI.CLASS_D.getDescription() : ((Integer)this.rssiRange.getFrom() == -90 && (Integer)this.rssiRange.getTo() == -86 ? RSSI.CLASS_E.getDescription() : ((Integer)this.rssiRange.getFrom() == -92 && (Integer)this.rssiRange.getTo() == -91 ? RSSI.CLASS_F.getDescription() : RSSI.CLASS_G.getDescription())))));
        }
        return String.format("%s", description);
    }

    public static enum RSSI {
        CLASS_A("CLASS_A", ">= -70"),
        CLASS_B("CLASS_B", "-75 to -71"),
        CLASS_C("CLASS_C", "-80 to -76"),
        CLASS_D("CLASS_D", "-85 to -81"),
        CLASS_E("CLASS_E", "-90 to -86"),
        CLASS_F("CLASS_F", "-92 to -91"),
        CLASS_G("CLASS_G", "<= -93"),
        UNKNOWN("UNKNOWN", "Unknown RSSI value");

        private final String identifier;
        private final String description;

        private RSSI(String identifier, String description) {
            this.identifier = identifier;
            this.description = description;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

