/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.labelstatistics;

import at.mrdevelopment.esl.labelstatistics.LabelStatistics;
import at.mrdevelopment.esl.labelstatistics.StatisticCategory;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.toolkit.Range;

public class LqiLabelInfo
extends LabelStatistics {
    private final Range<Integer> lqiRange;

    public LqiLabelInfo(StatisticCategory statisticCategory, Range<Integer> lqiRange, int totalLabels) {
        super(statisticCategory, totalLabels);
        this.lqiRange = lqiRange;
    }

    @Override
    public void process(LabelInfo labelInfo) {
        if (this.lqiRange == null) {
            if (labelInfo.getLqi() == null) {
                ++this.count;
            }
        } else if (labelInfo.getLqi() != null && this.lqiRange.contains((Comparable)labelInfo.getLqi())) {
            ++this.count;
        }
    }

    @Override
    public String getIdentifier() {
        String identifier = LQI.UNKNOWN.getIdentifier();
        if (this.lqiRange != null) {
            identifier = (Integer)this.lqiRange.getFrom() < 64 ? LQI.GOOD.getIdentifier() : LQI.BAD.getIdentifier();
        }
        return String.format("%s", identifier);
    }

    @Override
    public String getDescription() {
        String description = LQI.UNKNOWN.getDescription();
        if (this.lqiRange != null) {
            description = (Integer)this.lqiRange.getFrom() < 64 ? LQI.GOOD.getDescription() : LQI.BAD.getDescription();
        }
        return String.format("%s", description);
    }

    public static enum LQI {
        GOOD("GOOD", "<= 63"),
        BAD("BAD", ">= 64"),
        UNKNOWN("UNKNOWN", "Unknown LQI value");

        private final String identifier;
        private final String description;

        private LQI(String identifier, String description) {
            this.identifier = identifier;
            this.description = description;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

