/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.labelstatistics;

import at.mrdevelopment.esl.labelstatistics.LabelStatistics;
import at.mrdevelopment.esl.labelstatistics.StatisticCategory;
import at.mrdevelopment.esl.persistence.record.LabelInfo;

public class HardwareErrorsLabelInfo
extends LabelStatistics {
    private final HardwareErrors hardwareErrors;

    public HardwareErrorsLabelInfo(StatisticCategory statisticCategory, HardwareErrors hardwareErrors, int totalLabels) {
        super(statisticCategory, totalLabels);
        this.hardwareErrors = hardwareErrors;
    }

    @Override
    public void process(LabelInfo labelInfo) {
        if (labelInfo.getLabelErrors() == null) {
            if (this.hardwareErrors.equals((Object)HardwareErrors.UNKNOWN)) {
                ++this.count;
            }
        } else if (labelInfo.getLabelErrors().hasErrors() && this.hardwareErrors.equals((Object)HardwareErrors.HAS_HARDWARE_ERRORS)) {
            ++this.count;
        } else if (!labelInfo.getLabelErrors().hasErrors() && this.hardwareErrors.equals((Object)HardwareErrors.HAS_NO_HARDWARE_ERRORS)) {
            ++this.count;
        }
    }

    @Override
    public String getIdentifier() {
        return String.format("%s", this.hardwareErrors == null ? HardwareErrors.UNKNOWN.getIdentifier() : this.hardwareErrors.getIdentifier());
    }

    @Override
    public String getDescription() {
        return String.format("%s", this.hardwareErrors == null ? HardwareErrors.UNKNOWN.getDescription() : this.hardwareErrors.getDescription());
    }

    public static enum HardwareErrors {
        HAS_HARDWARE_ERRORS("HARDWARE_ERRORS", "Device has hardware errors"),
        HAS_NO_HARDWARE_ERRORS("NO_HARDWARE_ERRORS", "Device has no hardware errors"),
        UNKNOWN("UNKNOWN", "Unknown hardware error status");

        private final String identifier;
        private final String description;

        private HardwareErrors(String identifier, String description) {
            this.identifier = identifier;
            this.description = description;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

