/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.dialog;

import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.gui.editor.ServiceAddressEditor;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChooseServerDialog {
    private JDialog dialog;
    private JFrame parent;
    private int result = -1;
    private Collection<ServiceAddress> permanentEntries;
    private ServiceAddressEditor serviceAddressTextField;

    public ChooseServerDialog(JFrame parent, Collection<ServiceAddress> permanentEntries) {
        this.parent = parent;
        this.permanentEntries = new HashSet<ServiceAddress>(permanentEntries);
    }

    private void initDialog() {
        this.dialog = new JDialog(this.parent, "Choose server", true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setResizable(false);
        final DefaultListModel<ServiceAddress> listModel = new DefaultListModel<ServiceAddress>();
        JPanel buttonPanel = new JPanel(new FlowLayout());
        for (ServiceAddress serviceAddress : this.permanentEntries) {
            listModel.addElement(serviceAddress);
        }
        final JList list = new JList(listModel);
        list.setSelectionMode(0);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedIndex = list.getSelectedIndex();
                if (selectedIndex >= 0) {
                    ChooseServerDialog.this.serviceAddressTextField.setValue((Object)((ServiceAddress)list.getSelectedValue()).toString());
                }
            }
        });
        list.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    int selectedIndex = list.getSelectedIndex();
                    if (selectedIndex >= 0) {
                        ChooseServerDialog.this.serviceAddressTextField.setValue((Object)((ServiceAddress)list.getSelectedValue()).toString());
                    }
                    ChooseServerDialog.this.onApplyButton();
                }
            }
        });
        JButton applyButton = new JButton("Apply");
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseServerDialog.this.onApplyButton();
            }
        });
        buttonPanel.add(applyButton);
        JButton removeSelectedButton = new JButton("Remove");
        removeSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (list.getSelectedIndex() >= 0) {
                    ChooseServerDialog.this.permanentEntries.remove(((DefaultListModel)list.getModel()).remove(list.getSelectedIndex()));
                }
            }
        });
        buttonPanel.add(removeSelectedButton);
        JButton clearAllButton = new JButton("Remove all");
        clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listModel.removeAllElements();
                ChooseServerDialog.this.permanentEntries.clear();
            }
        });
        buttonPanel.add(clearAllButton);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.serviceAddressTextField = new ServiceAddressEditor();
        bottomPanel.add((Component)this.serviceAddressTextField.getEditorComponent(), "Center");
        bottomPanel.add((Component)buttonPanel, "South");
        this.dialog.add((Component)new JScrollPane(list), "Center");
        this.dialog.add((Component)bottomPanel, "South");
        this.registerEscapeKeyAction();
        this.dialog.getRootPane().setDefaultButton(applyButton);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.parent);
        this.dialog.setVisible(true);
    }

    private void registerEscapeKeyAction() {
        this.dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseServerDialog.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    protected void onApplyButton() {
        this.serviceAddressTextField.validate();
        if (!this.serviceAddressTextField.hasErrors()) {
            this.updatePermanentEntries();
            this.close();
        }
    }

    private void updatePermanentEntries() {
        try {
            ServiceAddress address = this.getAddress();
            Collection addressStrings = Collections2.transform(this.permanentEntries, (Function)new Function<ServiceAddress, String>(){

                public String apply(ServiceAddress address) {
                    return address.toString();
                }
            });
            if (!addressStrings.contains(address.toString())) {
                this.permanentEntries.add(address);
            }
            this.result = 0;
        }
        catch (MalformedURLException e) {
            this.result = -1;
        }
    }

    public boolean isCancelled() {
        return this.result != 0;
    }

    public ServiceAddress getAddress() throws MalformedURLException {
        URL url;
        String address = this.serviceAddressTextField.getValue();
        if (!address.startsWith("http://") && !address.startsWith("https://")) {
            address = "http://" + address;
        }
        if ((url = new URL(address)).getPort() == -1) {
            address = address + ":8000";
        }
        return ServiceAddress.fromString((String)address);
    }

    public Collection<ServiceAddress> getEntries() {
        return this.permanentEntries;
    }

    public int show() {
        this.result = -1;
        this.initDialog();
        return this.result;
    }

    private void close() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }
}

