/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.security.UnlockCode;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class UnlockCodeTableModel
extends AbstractTableModel {
    static ESLLogger logger = ESLLogger.getLogger(UnlockCodeTableModel.class);
    private static final int LABEL_ID_COLUMN = 0;
    private static final int TYPE_COLUMN = 1;
    private static final int PUK_COLUMN = 2;
    private final Map<LabelId, Integer> labels = new HashMap<LabelId, Integer>();
    private final List<UnlockCode> unlockCodes = new ArrayList<UnlockCode>();

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return LabelId.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Label ID";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Puk";
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.unlockCodes.get(row).getLabelId().getLabelIdString();
            }
            case 1: {
                return this.unlockCodes.get(row).getLabelId().getLabelType().getName();
            }
            case 2: {
                return true;
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.unlockCodes.size();
    }

    public void addUnlockCode(UnlockCode unlockCode) {
        this.internalAddUnlockCode(unlockCode, true);
    }

    public void addUnlockCodes(Collection<UnlockCode> unlockCodes) {
        for (UnlockCode unlockCode : unlockCodes) {
            this.internalAddUnlockCode(unlockCode, false);
        }
        this.fireTableDataChanged();
    }

    public void removeLabel(LabelId label) {
        if (this.labels.containsKey(label)) {
            int index = this.labels.get(label);
            this.labels.remove(label);
            this.unlockCodes.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
        this.rebuildIndex();
    }

    public void clear() {
        if (this.unlockCodes.size() > 0) {
            int lastRow = this.unlockCodes.size() - 1;
            this.labels.clear();
            this.unlockCodes.clear();
            this.fireTableRowsDeleted(0, lastRow);
        }
    }

    public Collection<UnlockCode> getUnlockCodes() {
        return Collections.unmodifiableCollection(this.unlockCodes);
    }

    public UnlockCode getUnlockCode(int row) {
        return this.unlockCodes.get(row);
    }

    public LabelId getLabel(int row) {
        return this.unlockCodes.get(row).getLabelId();
    }

    public boolean isEmpty() {
        return this.unlockCodes.isEmpty();
    }

    private void internalAddUnlockCode(UnlockCode unlockCode, boolean fireEvent) {
        LabelId label = unlockCode.getLabelId();
        if (!this.labels.containsKey(label)) {
            int index = this.unlockCodes.size();
            this.labels.put(label, index);
            this.unlockCodes.add(unlockCode);
            if (fireEvent) {
                this.fireTableRowsInserted(index, index);
            }
        }
    }

    private void rebuildIndex() {
        this.labels.clear();
        for (int index = 0; index < this.unlockCodes.size(); ++index) {
            LabelId label = this.unlockCodes.get(index).getLabelId();
            this.labels.put(label, index);
        }
    }
}

