/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.flashing;

import at.mrdevelopment.esl.flashing.LEDColor;
import at.mrdevelopment.esl.flashing.LEDPattern;
import at.mrdevelopment.esl.flashing.LabelLED;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class BasicLED
implements LabelLED {
    public static final int MAX_COUNT = 31;
    public static final int MAX_DURATION = Integer.MAX_VALUE;
    private LEDColor color;
    private LEDPattern pattern;
    private int durationInMinutes;
    private int repeatCount;

    public static BasicLED createWithDuration(LEDColor color, LEDPattern pattern, int durationInMinutes) {
        return new BasicLED(color, pattern, durationInMinutes, 0);
    }

    public static BasicLED createWithCount(LEDColor color, LEDPattern pattern, int repeatCount) {
        return new BasicLED(color, pattern, 0, repeatCount);
    }

    public BasicLED(LEDColor color, LEDPattern pattern, int durationInMinutes, int repeatCount) {
        this.color = color;
        this.pattern = pattern;
        this.durationInMinutes = durationInMinutes;
        this.repeatCount = repeatCount;
    }

    public LEDColor getColor() {
        return this.color;
    }

    public LEDPattern getPattern() {
        return this.pattern;
    }

    public int getDurationInMinutes() {
        return this.durationInMinutes;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public boolean isRepeat() {
        return this.durationInMinutes == 0 && this.repeatCount > 0;
    }

    @Override
    public Map<String, String> getLEDData() {
        return ImmutableMap.builder().put((Object)"type", (Object)this.getClass().getSimpleName()).put((Object)"color", (Object)String.valueOf(this.color.getValue())).put((Object)"pattern", (Object)String.valueOf(this.pattern.getValue())).put((Object)"durationInMinutes", (Object)String.valueOf(this.durationInMinutes)).put((Object)"repeatCount", (Object)String.valueOf(this.repeatCount)).build();
    }
}

