/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.firmware;

import at.mrdevelopment.esl.firmware.FirmwareLoader;
import at.mrdevelopment.esl.firmware.FirmwareSource;
import at.mrdevelopment.toolkit.FirmwareImage;
import at.mrdevelopment.toolkit.HexFileFormat;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.firmware.Firmware;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;

public class FileFirmwareSource
implements FirmwareSource {
    private final String firmwareFilename;
    private FirmwareLoader firmwareLoader;

    public FileFirmwareSource(String firmwareFilename) {
        this.firmwareFilename = firmwareFilename;
    }

    public String getFirmwareFilename() {
        return this.firmwareFilename;
    }

    public boolean isHexFormatFile() {
        return FilenameUtils.isExtension((String)this.firmwareFilename.toLowerCase(), (String)"hex");
    }

    public boolean isXmlFormatFile() {
        return FilenameUtils.isExtension((String)this.firmwareFilename.toLowerCase(), (String)"xml");
    }

    @Override
    public boolean isUpdateToLatestFirmware() {
        return this.firmwareFilename.equals("latest");
    }

    @Override
    public FirmwareImage getFirmwareImage() throws SerializeException, IOException {
        if (this.firmwareLoader == null) {
            try {
                this.firmwareLoader = new FirmwareLoader();
            }
            catch (InitializationException exc) {
                throw new SerializeException((Throwable)exc);
            }
        }
        if (this.isHexFormatFile()) {
            File firmwareImageFile = new File(this.getFirmwareFilename());
            return FirmwareImage.load((File)firmwareImageFile, (HexFileFormat)HexFileFormat.CC2510);
        }
        if (this.isXmlFormatFile()) {
            Firmware firmware = this.firmwareLoader.loadFirmware(this.getFirmwareFilename(), HexFileFormat.CC2510);
            return firmware.getFirmwareImage();
        }
        throw new SerializeException("Unknown firmware file format (%s)", new Object[]{this.firmwareFilename});
    }

    @Override
    public String getData() {
        return this.firmwareFilename;
    }
}

