/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.csvimport;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.security.Puk;
import at.mrdevelopment.esl.core.security.UnlockCode;
import at.mrdevelopment.esl.csvimport.CsvImport;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.List;

public class UnlockCodeCsvImport
extends CsvImport<UnlockCode> {
    @Override
    protected List<UnlockCode> importRecords(List<String[]> records) throws SerializeException {
        ArrayList<UnlockCode> unlockCodes = new ArrayList<UnlockCode>(records.size());
        for (String[] record : records) {
            UnlockCode unlockCode;
            if (record.length == 2) {
                LabelId labelId = LabelId.fromString(record[0]);
                Puk puk = Puk.fromHexString((String)record[1]);
                unlockCode = this.parseCode(labelId, puk);
            } else {
                String code = record[0];
                unlockCode = this.parseCode(code);
            }
            unlockCodes.add(unlockCode);
        }
        return unlockCodes;
    }

    private UnlockCode parseCode(LabelId labelId, Puk puk) {
        return new UnlockCode(labelId, puk);
    }

    private UnlockCode parseCode(String code) throws SerializeException {
        return UnlockCode.fromBase58(code);
    }
}

