/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.csvimport;

import at.mrdevelopment.toolkit.file.CsvReader;
import at.mrdevelopment.toolkit.file.FileReader;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public abstract class CsvImport<T> {
    protected final FileReader csvReader;

    public CsvImport() {
        this((FileReader)new CsvReader());
    }

    public CsvImport(FileReader csvReader) {
        this.csvReader = csvReader;
    }

    public List<T> importFromFile(File importFile) throws FileNotFoundException, IOException, SerializeException {
        List records = this.csvReader.read(importFile);
        return this.internalImportRecords(records);
    }

    public List<T> importFromFile(File importFile, String charsetName) throws FileNotFoundException, IOException, SerializeException {
        List records = this.csvReader.read(importFile, charsetName);
        return this.internalImportRecords(records);
    }

    public List<T> importFromStream(InputStream inputStream) throws IOException, SerializeException {
        List records = this.csvReader.read(inputStream);
        return this.internalImportRecords(records);
    }

    public List<T> importFromStream(InputStream inputStream, String charsetName) throws IOException, SerializeException {
        List records = this.csvReader.read(inputStream, charsetName);
        return this.internalImportRecords(records);
    }

    private List<T> internalImportRecords(List<String[]> records) throws SerializeException {
        try {
            return this.importRecords(records);
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw new SerializeException("Invalid file format", new Object[0]);
        }
    }

    protected abstract List<T> importRecords(List<String[]> var1) throws SerializeException;
}

