/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.csvimport;

import at.mrdevelopment.esl.core.ConfigurationType;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.csvimport.CsvImport;
import at.mrdevelopment.esl.persistence.record.AccessPointConfiguration;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AccessPointConfigurationCsvImport
extends CsvImport<AccessPointConfiguration> {
    @Override
    protected List<AccessPointConfiguration> importRecords(List<String[]> records) throws SerializeException {
        ArrayList<AccessPointConfiguration> configurationRecords = new ArrayList<AccessPointConfiguration>(records.size());
        for (String[] record : records) {
            AccessPointConfiguration configuration = new AccessPointConfiguration();
            configuration.setAccessPointId(Integer.parseInt(record[0]));
            configuration.setAddress(record[1]);
            if (!record[2].isEmpty()) {
                configuration.setPort(Integer.parseInt(record[2]));
            } else {
                configuration.setPort(-1);
            }
            configuration.setSsl(Boolean.parseBoolean(record[3]));
            configuration.setHostName(record[4]);
            configuration.setSubnetMask(record[5]);
            configuration.setGateway(record[6]);
            configuration.setDns(record[7]);
            String channel = record[8];
            if (channel != null && !channel.isEmpty()) {
                configuration.setChannel(WirelessChannel.fromString((String)record[8]));
            }
            if (record.length == 10) {
                String type = record[9];
                if (StringUtils.isNotEmpty((String)type)) {
                    configuration.setType(ConfigurationType.valueOf((String)type));
                }
            } else if (StringUtils.isNotEmpty((String)configuration.getHostName())) {
                configuration.setType(ConfigurationType.CENTRALIZED);
            } else {
                configuration.setType(ConfigurationType.MANUAL);
            }
            configurationRecords.add(configuration);
        }
        return configurationRecords;
    }
}

