/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.security;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.Base58;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;

public class RegistrationCode {
    public static final int LENGTH = 11;
    public static final int LENGHT_WITHOUT_CHECKSUM = 10;
    private static final byte[] PADDING = new byte[]{2};
    private static final byte[] PADDING_ALTERNATE = new byte[]{3};
    private final LabelId labelId;
    private final Pin pin;
    private final boolean alternatePadding;

    public static RegistrationCode fromBase58(String encodedWithChecksum) throws SerializeException {
        if (encodedWithChecksum.length() != 11) {
            throw new SerializeException("Invalid registration code length", new Object[0]);
        }
        String encoded = encodedWithChecksum.substring(0, 10);
        char checksum = encodedWithChecksum.charAt(10);
        if (Base58.calculateCheckSum((String)encoded) != checksum) {
            throw new SerializeException("Invalid checksum", new Object[0]);
        }
        byte[] decoded = Base58.decode((String)encoded);
        if (decoded == null) {
            throw new SerializeException("Registration code contains illegal characters", new Object[0]);
        }
        byte padding = decoded[0];
        if (padding != PADDING[0] && padding != PADDING_ALTERNATE[0]) {
            throw new SerializeException("Not a valid registration code (wrong padding)", new Object[0]);
        }
        Pin pin = Pin.fromBytes((byte[])Arrays.copyOfRange(decoded, 1, 4));
        LabelId labelId = new LabelId(Address.fromByteArray((byte[])Arrays.copyOfRange(decoded, 4, 8)));
        labelId.validate();
        return new RegistrationCode(labelId, pin, padding == PADDING_ALTERNATE[0]);
    }

    public RegistrationCode(LabelId labelId, Pin pin) {
        this(labelId, pin, false);
    }

    public RegistrationCode(LabelId labelId, Pin pin, boolean alternatePadding) {
        this.labelId = labelId;
        this.pin = pin;
        this.alternatePadding = alternatePadding;
    }

    public LabelId getLabelId() {
        return this.labelId;
    }

    public Pin getPin() {
        return this.pin;
    }

    public boolean hasAlternatePadding() {
        return this.alternatePadding;
    }

    public String toBase58() {
        byte[] input = ArrayUtils.addAll((byte[])this.pin.toBytes(), (byte[])this.labelId.toAddress().toByteArray());
        byte[] paddedInput = ArrayUtils.addAll((byte[])(this.alternatePadding ? PADDING_ALTERNATE : PADDING), (byte[])input);
        return Base58.encodeWithChecksum((byte[])paddedInput);
    }

    public String toString() {
        return this.toBase58();
    }
}

