/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.core.TransmissionStatistic;
import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.tasks.ErrorTask;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.type.UpdateResult;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.update.Update;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import java.util.UUID;
import org.joda.time.DateTime;

public class UpdateResultFactory {
    public UpdateResult createFromUpdate(Update update) {
        LabelId labelId = update.getLabelId();
        TaskType taskType = update.getTaskType();
        UUID taskId = update.getTaskId();
        long externalId = update.getExternalId();
        Status status = update.getStatus();
        Integer errorCode = update.getErrorCode();
        DateTime finishedAt = update.getUpdatedAt();
        if (update.isAssigned()) {
            Integer accessPointId = update.getAccessPointId();
            PowerStatus powerStatus = update.getPowerStatus();
            Integer rssi = update.getUpdateStatus().getRssi();
            Integer lqi = update.getUpdateStatus().getLqi();
            Integer transmissionTime = update.getUpdateStatus().getTransmissionTime();
            return new UpdateResult(labelId, taskType, taskId, externalId, status, errorCode, accessPointId, finishedAt, powerStatus, rssi, lqi, transmissionTime);
        }
        return new UpdateResult(labelId, taskType, taskId, externalId, status, errorCode, finishedAt);
    }

    public UpdateResult createFromUpdateTask(Task task, ExternalUpdateTask updateTask, WakeupStatistic wakeupStatistic) {
        TransmissionStatistic transmissionStatistic;
        LabelId labelId = new LabelId(updateTask.getAddress());
        TaskType taskType = task instanceof ExecutableTask ? ((ExecutableTask)task).getTaskType() : TaskType.UNKNOWN;
        UUID taskId = updateTask.getTaskId();
        long externalId = task.getExternalId();
        UpdateTaskStatus status = updateTask.getStatus();
        Integer errorCode = updateTask.getUpdateError() != null ? Integer.valueOf(updateTask.getUpdateError().getCode()) : null;
        DateTime finishedAt = updateTask.getUpdatedAtTime();
        PowerStatus powerStatus = PowerStatus.UNKNOWN;
        Integer accessPointId = 0;
        Integer rssi = 0;
        Integer lqi = 0;
        Integer transmissionTime = 0;
        if (wakeupStatistic != null) {
            powerStatus = wakeupStatistic.getPowerStatus();
            accessPointId = wakeupStatistic.getAccessPointId();
        }
        if ((transmissionStatistic = updateTask.getTransmissionStatistic()).hasFullStatistic()) {
            rssi = updateTask.getTransmissionStatistic().getRssi();
            lqi = updateTask.getTransmissionStatistic().getLqi();
        }
        if (transmissionStatistic.hasTransmissionTime()) {
            transmissionTime = updateTask.getTransmissionStatistic().getTransmissionTime();
        }
        return new UpdateResult(labelId, taskType, taskId, externalId, status.toStatus(), errorCode, accessPointId, finishedAt, powerStatus, rssi, lqi, transmissionTime);
    }

    public UpdateResult createFromErrorTask(ErrorTask errorTask, WakeupStatistic wakeupStatistic) {
        LabelId labelId = errorTask.getLabelId();
        UUID taskId = UUID.randomUUID();
        long externalId = errorTask.getExternalId();
        Status status = Status.ERROR;
        int errorCode = errorTask.getUpdateError().getCode();
        PowerStatus powerStatus = PowerStatus.UNKNOWN;
        Integer accessPointId = null;
        Integer rssi = null;
        Integer lqi = null;
        if (wakeupStatistic != null) {
            accessPointId = wakeupStatistic.getAccessPointId();
            powerStatus = wakeupStatistic.getPowerStatus();
            rssi = wakeupStatistic.getLastRssi();
            lqi = wakeupStatistic.getLastLqi();
        }
        return new UpdateResult(labelId, errorTask.getTaskType(), taskId, externalId, status, errorCode, accessPointId, DateTime.now(), powerStatus, rssi, lqi, null);
    }
}

