/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.TagUtils;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.core.security.RegistrationCode;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LabelRegistration {
    private final LabelId labelId;
    private final Pin pin;
    private final Set<String> tags;

    public static Collection<LabelRegistration> fromRegistrationCodes(Collection<RegistrationCode> registrationCode) {
        return Collections2.transform(registrationCode, (Function)new Function<RegistrationCode, LabelRegistration>(){

            public LabelRegistration apply(RegistrationCode registrationCode) {
                return new LabelRegistration(registrationCode.getLabelId(), registrationCode.getPin(), Collections.<String>emptySet());
            }
        });
    }

    public static Collection<LabelRegistration> fromLabelIds(Collection<LabelId> labelIds) {
        return Collections2.transform(labelIds, (Function)new Function<LabelId, LabelRegistration>(){

            public LabelRegistration apply(LabelId labelId) {
                return new LabelRegistration(labelId, null);
            }
        });
    }

    public static Collection<LabelRegistration> fromLabelIds(Collection<LabelId> labelIds, final Set<String> tags) {
        return Collections2.transform(labelIds, (Function)new Function<LabelId, LabelRegistration>(){

            public LabelRegistration apply(LabelId labelId) {
                return new LabelRegistration(labelId, null, tags);
            }
        });
    }

    public static Collection<LabelRegistration> fromAddresses(Collection<Address> addresses) {
        return Collections2.transform(addresses, (Function)new Function<Address, LabelRegistration>(){

            public LabelRegistration apply(Address address) {
                return new LabelRegistration(new LabelId(address), null);
            }
        });
    }

    public static LabelRegistration fromRegistrationCodeOrLabelId(String registrationCodeOrLabelId, Set<String> tags) throws SerializeException {
        if (registrationCodeOrLabelId.length() == 8) {
            return new LabelRegistration(LabelId.fromString(registrationCodeOrLabelId), null, tags);
        }
        RegistrationCode registrationCode = RegistrationCode.fromBase58(registrationCodeOrLabelId);
        return new LabelRegistration(registrationCode.getLabelId(), registrationCode.getPin(), tags);
    }

    public LabelRegistration(LabelId labelId, Pin pin, Set<String> tags) {
        this.labelId = labelId;
        this.pin = pin;
        this.tags = new HashSet<String>(tags);
    }

    public LabelRegistration(LabelId labelId, Pin pin) {
        this.labelId = labelId;
        this.pin = pin;
        this.tags = Collections.emptySet();
    }

    public LabelId getLabelId() {
        return this.labelId;
    }

    public Pin getPin() {
        return this.pin;
    }

    public boolean hasPin() {
        return this.pin != null;
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public String getTagsString() {
        return TagUtils.toString(this.tags);
    }
}

