/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.security.RegistrationCode;
import at.mrdevelopment.toolkit.math.ChecksumCalculator;
import com.google.common.base.Strings;

public class LabelInitialization {
    private final LabelId labelId;
    private final RegistrationCode registrationCode;
    private final String serialNumber;
    private final String labelType;
    private final String edition;
    private final int orientation;
    private final String checksum;

    public LabelInitialization(LabelId labelId, RegistrationCode registrationCode, String serialNumber, String labelType, String edition, int orientation) {
        this.labelId = labelId;
        this.registrationCode = registrationCode;
        this.serialNumber = serialNumber;
        this.labelType = labelType;
        this.edition = edition;
        this.orientation = orientation;
        this.checksum = LabelInitialization.calculateChecksum(labelId);
    }

    private static String calculateChecksum(LabelId labelId) {
        return ChecksumCalculator.calculateChecksumForLabel((String)labelId.getLabelIdString());
    }

    public LabelId getLabelId() {
        return this.labelId;
    }

    public boolean hasRegistrationCode() {
        return this.registrationCode != null;
    }

    public RegistrationCode getRegistrationCode() {
        return this.registrationCode;
    }

    public boolean hasSerialNumber() {
        return Strings.isNullOrEmpty((String)this.serialNumber);
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public boolean hasLabelType() {
        return this.labelType != null;
    }

    public String getLabelType() {
        return this.labelType;
    }

    public boolean hasEdition() {
        return !Strings.isNullOrEmpty((String)this.edition);
    }

    public String getEdition() {
        return this.edition;
    }

    public boolean hasOrientation() {
        return this.orientation > 0;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public String getChecksum() {
        return this.checksum;
    }
}

