/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.core.labeltype.LabelTypeMapping;
import at.mrdevelopment.esl.wireless.Address;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public enum DefaultLabelTypeMapping implements LabelTypeMapping
{
    INSTANCE;

    private final Map<Integer, LabelType> labelTypeMapping = new HashMap<Integer, LabelType>();

    private DefaultLabelTypeMapping() {
        this.add(16, LabelType.UNKNOWN);
        this.add(17, LabelType.UNKNOWN);
        this.add(18, LabelType.UNKNOWN);
        this.add(19, LabelType.UNKNOWN);
        this.add(20, LabelType.UNKNOWN);
        this.add(21, LabelType.UNKNOWN);
        this.add(22, LabelType.UNKNOWN);
        this.add(23, LabelType.DISPLAY_RAIL_DEMO_132_SMALL);
        this.add(24, LabelType.DISPLAY_RAIL_DEMO_132_MEDIUM);
        this.add(25, LabelType.DISPLAY_RAIL_DEMO_132_LARGE);
        this.add(26, LabelType.TESTBOX_270);
        this.add(27, LabelType.UNKNOWN);
        this.add(28, LabelType.UNKNOWN);
        this.add(29, LabelType.BATTERY_SEGMENTED);
        this.add(30, LabelType.BATTERY_SEGMENTED);
        this.add(31, LabelType.BATTERY_SEGMENTED);
        this.add(160, LabelType.UNKNOWN);
        this.add(161, LabelType.BATTERY_200);
        this.add(162, LabelType.BATTERY_200_FLIPPED);
        this.add(163, LabelType.UNKNOWN);
        this.add(164, LabelType.BOSSARD);
        this.add(165, LabelType.BATTERY_220_RED);
        this.add(166, LabelType.BATTERY_220);
        this.add(167, LabelType.BATTERY_220_BWY);
        this.add(168, LabelType.UNKNOWN);
        this.add(169, LabelType.UNKNOWN);
        this.add(170, LabelType.UNKNOWN);
        this.add(171, LabelType.UNKNOWN);
        this.add(172, LabelType.UNKNOWN);
        this.add(173, LabelType.UNKNOWN);
        this.add(174, LabelType.UNKNOWN);
        this.add(175, LabelType.UNKNOWN);
        this.add(176, LabelType.UNKNOWN);
        this.add(177, LabelType.BATTERY_270_FLIPPED);
        this.add(178, LabelType.BATTERY_270);
        this.add(179, LabelType.BATTERY_270);
        this.add(180, LabelType.G1_0270_BW_270);
        this.add(181, LabelType.BATTERY_270_RED);
        this.add(182, LabelType.BATTERY_260_RED);
        this.add(183, LabelType.BATTERY_260);
        this.add(184, LabelType.BATTERY_260_BWY);
        this.add(185, LabelType.BATTERY_270_BWY);
        this.add(186, LabelType.G1_0260_BW_090);
        this.add(187, LabelType.G1_0260_BWR_090);
        this.add(188, LabelType.G1_0260_BWY_090);
        this.add(189, LabelType.G1_0270_BWR_090);
        this.add(190, LabelType.BATTERY_290_RED);
        this.add(191, LabelType.G1_0260_BWR_090);
        this.add(192, LabelType.UNKNOWN);
        this.add(193, LabelType.BATTERY_441);
        this.add(194, LabelType.UNKNOWN);
        this.add(195, LabelType.UNKNOWN);
        this.add(196, LabelType.BATTERY_441_RED);
        this.add(197, LabelType.BATTERY_420_RED);
        this.add(198, LabelType.BATTERY_450_RED);
        this.add(199, LabelType.BATTERY_420);
        this.add(200, LabelType.BATTERY_450);
        this.add(201, LabelType.BATTERY_420_BWY);
        this.add(202, LabelType.BATTERY_450_BWY);
        this.add(203, LabelType.G1_0450_BWR_090);
        this.add(204, LabelType.G1_0370_BWR_090);
        this.add(205, LabelType.UNKNOWN);
        this.add(206, LabelType.UNKNOWN);
        this.add(207, LabelType.UNKNOWN);
        this.add(208, LabelType.UNKNOWN);
        this.add(209, LabelType.BATTERY_740);
        this.add(210, LabelType.UNKNOWN);
        this.add(211, LabelType.BATTERY_740_RED);
        this.add(212, LabelType.BATTERY_600_RED);
        this.add(213, LabelType.BATTERY_600_BWY);
        this.add(214, LabelType.BATTERY_740_BWY);
        this.add(215, LabelType.BATTERY_600);
        this.add(216, LabelType.UNKNOWN);
        this.add(217, LabelType.G1_0590_BWR_270);
        this.add(218, LabelType.G1_0970_BWR_090);
        this.add(219, LabelType.G1_0970_BWR_270);
        this.add(220, LabelType.UNKNOWN);
        this.add(221, LabelType.UNKNOWN);
        this.add(222, LabelType.UNKNOWN);
        this.add(223, LabelType.UNKNOWN);
        this.add(224, LabelType.UNKNOWN);
        this.add(225, LabelType.BATTERY_1020);
        this.add(226, LabelType.UNKNOWN);
        this.add(227, LabelType.BATTERY_1200);
        this.add(228, LabelType.BATTERY_1200_RED);
        this.add(229, LabelType.BATTERY_1200_BWY);
        this.add(230, LabelType.UNKNOWN);
        this.add(231, LabelType.UNKNOWN);
        this.add(232, LabelType.UNKNOWN);
        this.add(233, LabelType.UNKNOWN);
        this.add(234, LabelType.UNKNOWN);
        this.add(235, LabelType.UNKNOWN);
        this.add(236, LabelType.UNKNOWN);
        this.add(237, LabelType.UNKNOWN);
        this.add(238, LabelType.UNKNOWN);
        this.add(239, LabelType.UNKNOWN);
        this.add(240, LabelType.UNKNOWN);
        this.add(241, LabelType.BATTERY_160_RED);
        this.add(242, LabelType.STAG_256);
        this.add(243, LabelType.BATTERY_160);
        this.add(244, LabelType.SES_GTAG_6);
        this.add(245, LabelType.BATTERY_160_BWY);
        this.add(246, LabelType.G1_0160_BW_090);
        this.add(247, LabelType.G1_0160_BWR_090);
        this.add(248, LabelType.G1_0160_BWY_090);
        this.add(249, LabelType.G1_0260_BW_090);
        this.add(250, LabelType.G1_0220_BW_090);
        this.add(251, LabelType.G1_0260_BW_270);
        this.add(252, LabelType.UNKNOWN);
        this.add(253, LabelType.UNKNOWN);
        this.add(254, LabelType.UNKNOWN);
        this.add(255, LabelType.UNKNOWN);
    }

    public static void main(String[] args) {
        LabelType labelType;
        System.out.format("By type identifier%n%n", new Object[0]);
        for (Map.Entry<Integer, LabelType> entry : new TreeMap<Integer, LabelType>(DefaultLabelTypeMapping.INSTANCE.labelTypeMapping).entrySet()) {
            int n = entry.getKey();
            LabelType labelType2 = entry.getValue();
            System.out.format("%02X = %s %s%n", n, labelType2.isNonStandardDefinition() ? "!" : " ", labelType2);
        }
        System.out.format("%n%n%n", new Object[0]);
        System.out.format("By label type%n%n", new Object[0]);
        TreeMap<LabelType, ArrayList<Integer>> inverseMap = new TreeMap<LabelType, ArrayList<Integer>>();
        for (Map.Entry<Integer, LabelType> entry : DefaultLabelTypeMapping.INSTANCE.labelTypeMapping.entrySet()) {
            int typeId = entry.getKey();
            labelType = entry.getValue();
            ArrayList<Integer> typeIds = (ArrayList<Integer>)inverseMap.get(labelType);
            if (typeIds == null) {
                typeIds = new ArrayList<Integer>();
                inverseMap.put(labelType, typeIds);
            }
            typeIds.add(typeId);
        }
        for (Map.Entry<Integer, Object> entry : inverseMap.entrySet()) {
            LabelType labelType3 = (LabelType)entry.getKey();
            List typeIds = (List)entry.getValue();
            System.out.format("%-22s = ", labelType3);
            Iterator i$ = typeIds.iterator();
            while (i$.hasNext()) {
                int typeId = (Integer)i$.next();
                System.out.format("%02X ", typeId);
            }
            System.out.format("%n", new Object[0]);
        }
        System.out.format("%n%n%n", new Object[0]);
        System.out.format("For Portal%n%n", new Object[0]);
        for (Map.Entry<Integer, Object> entry : new TreeMap<Integer, LabelType>(DefaultLabelTypeMapping.INSTANCE.labelTypeMapping).entrySet()) {
            int typeId = entry.getKey();
            labelType = (LabelType)entry.getValue();
            if (labelType == LabelType.UNKNOWN) continue;
            System.out.format("label;%02X;%s (%02X,r=%s,w=%s)%n", typeId, labelType.getName(), typeId, labelType.getImageRotation(), Address.fromString((String)String.format("%02X000000", typeId)).isSlowerWakeup() ? "30" : "15");
        }
        System.out.format("%n%n%n", new Object[0]);
        System.out.format("For LegacyLabelTypeMapping%n%n", new Object[0]);
        for (Map.Entry<Integer, Object> entry : new TreeMap<Integer, LabelType>(DefaultLabelTypeMapping.INSTANCE.labelTypeMapping).entrySet()) {
            int typeId = entry.getKey();
            labelType = (LabelType)entry.getValue();
            if (labelType == LabelType.UNKNOWN) continue;
            System.out.format("\t\tadd(0x%02X, LabelType.%s);%n", typeId, labelType);
        }
    }

    private void add(int typeId, LabelType labelType) {
        if (labelType == null) {
            throw new IllegalArgumentException("LabelType was null");
        }
        if (typeId < 0 || typeId > 255) {
            throw new IllegalArgumentException("Type identifier not within valid range");
        }
        LabelType assignedLabelType = this.labelTypeMapping.put(typeId, labelType);
        if (assignedLabelType != null) {
            throw new IllegalArgumentException(String.format("Type identifier %02X is already assigned to label type %s", typeId, assignedLabelType));
        }
    }

    public Map<Integer, LabelType> getMapping() {
        return Collections.unmodifiableMap(this.labelTypeMapping);
    }

    public LabelType getTypeForLabelId(LabelId labelId) {
        return this.getTypeForLabelId(labelId.getId());
    }

    public LabelType getTypeForLabelId(long labelId) {
        int code = (int)(labelId >> 24);
        LabelType labelType = this.labelTypeMapping.get(code);
        return labelType != null ? labelType : LabelType.UNKNOWN;
    }

    public static LabelType getType(long labelId) {
        return INSTANCE.getTypeForLabelId(labelId);
    }

    public static Set<Integer> getCodesForType(LabelType labelType) {
        HashSet<Integer> codes = new HashSet<Integer>();
        for (Map.Entry<Integer, LabelType> entry : DefaultLabelTypeMapping.INSTANCE.labelTypeMapping.entrySet()) {
            if (entry.getValue() != labelType) continue;
            codes.add(entry.getKey());
        }
        return codes;
    }
}

