/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.battery;

import at.mrdevelopment.esl.battery.BatteryCellConfig;
import at.mrdevelopment.esl.battery.BatteryLimits;
import at.mrdevelopment.esl.battery.BatterySample;
import at.mrdevelopment.esl.battery.BatteryType;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.labeltype.Display;
import at.mrdevelopment.esl.core.labeltype.LabelType;

public enum ProductConfig {
    DEFAULT_NO_CELL(BatteryType.DEFAULT, BatteryCellConfig.NO_CELL, new BatteryLimits(2.2, 2.3), false),
    DEFAULT_SINGLE(BatteryType.DEFAULT, BatteryCellConfig.SINGLE_CELL, new BatteryLimits(2.2, 2.3), false),
    DEFAULT_DOUBLE(BatteryType.DEFAULT, BatteryCellConfig.DOUBLE_CELL, new BatteryLimits(2.2, 2.3), false),
    DEFAULT_TRIPLE(BatteryType.DEFAULT, BatteryCellConfig.TRIPLE_CELL, new BatteryLimits(2.2, 2.3), false),
    DEFAULT_QUADRUPLE(BatteryType.DEFAULT, BatteryCellConfig.QUADRUPLE_CELL, new BatteryLimits(2.3, 2.4), false),
    DEFAULT_QUINTUPLE(BatteryType.DEFAULT, BatteryCellConfig.QUINTUPLE_CELL, new BatteryLimits(2.2, 2.3), false),
    DEFAULT_SEXTUPLE(BatteryType.DEFAULT, BatteryCellConfig.SEXTUPLE_CELL, new BatteryLimits(2.3, 2.4), false),
    DEFAULT_OCTUPLE(BatteryType.DEFAULT, BatteryCellConfig.OCTUPLE_CELL, new BatteryLimits(2.3, 2.4), false),
    FREEZER_DOUBLE(BatteryType.FREEZER, BatteryCellConfig.DOUBLE_CELL, new BatteryLimits(2.2, 2.3), false),
    FREEZER_DOUBLE_LOW(BatteryType.FREEZER, BatteryCellConfig.DOUBLE_CELL, new BatteryLimits(2.0, 2.1), true),
    POUCH_DOUBLE(BatteryType.POUCH_CELL, BatteryCellConfig.SINGLE_CELL, new BatteryLimits(2.2, 2.3), false),
    POUCH_DOUBLE_LOW(BatteryType.POUCH_CELL, BatteryCellConfig.SINGLE_CELL, new BatteryLimits(2.0, 2.1), true),
    POWERRAIL(BatteryType.POWER_RAIL, BatteryCellConfig.NO_CELL, BatteryLimits.NO_LIMIT, false),
    POWERRAIL_FREEZER(BatteryType.POWER_RAIL, BatteryCellConfig.NO_CELL, BatteryLimits.NO_LIMIT, true),
    UNKNOWN(BatteryType.UNKNOWN, BatteryCellConfig.NO_CELL, BatteryLimits.NO_LIMIT, false, false);

    private final BatteryType batteryType;
    private final BatteryCellConfig batteryCellConfig;
    private final BatteryLimits batteryLimits;
    private final boolean lowTemperature;
    private final boolean valid;

    private ProductConfig(BatteryType batteryType, BatteryCellConfig batteryCellConfig, BatteryLimits batteryLimits, boolean lowTemperature) {
        this(batteryType, batteryCellConfig, batteryLimits, lowTemperature, true);
    }

    private ProductConfig(BatteryType batteryType, BatteryCellConfig batteryCellConfig, BatteryLimits batteryLimits, boolean lowTemperature, boolean valid) {
        this.batteryType = batteryType;
        this.batteryCellConfig = batteryCellConfig;
        this.batteryLimits = batteryLimits;
        this.lowTemperature = lowTemperature;
        this.valid = valid;
    }

    public BatteryType getBatteryType() {
        return this.batteryType;
    }

    public BatteryCellConfig getBatteryCellConfig() {
        return this.batteryCellConfig;
    }

    public BatteryLimits getBatteryLimits() {
        return this.batteryLimits;
    }

    public boolean isLowTemperature() {
        return this.lowTemperature;
    }

    public static ProductConfig valueOf(int batteryInfo, boolean lowTemperature) {
        int numberOfCells = batteryInfo & 0xF;
        int batteryIdentifier = batteryInfo >> 4 & 0xF;
        BatteryType batteryType = BatteryType.valueOf(batteryIdentifier);
        BatteryCellConfig batteryCells = BatteryCellConfig.valueOf(numberOfCells);
        for (ProductConfig config : ProductConfig.values()) {
            if (config.getBatteryType() != batteryType || config.getBatteryCellConfig() != batteryCells || config.isLowTemperature() != lowTemperature) continue;
            return config;
        }
        return UNKNOWN;
    }

    public static ProductConfig fromLegacyLabel(LabelType labelType, boolean lowTemperature) {
        if (!lowTemperature) {
            Display display = labelType.getDisplay();
            if (display == Display.BW_1220 || display == Display.BWR_1220 || display == Display.BWY_1220) {
                return DEFAULT_SEXTUPLE;
            }
            if (display == Display.BW_740 || display == Display.BWR_740 || display == Display.BWY_740 || display == Display.BW_1020_TCON) {
                return DEFAULT_QUADRUPLE;
            }
            if (display == Display.BW_160 || display == Display.BWR_160 || display == Display.BWY_160 || display.getDisplaySize().getDisplayHeight() <= Display.BW_160.getDisplaySize().getDisplayHeight() && display.getDisplaySize().getDisplayWidth() <= Display.BW_160.getDisplaySize().getDisplayWidth()) {
                return DEFAULT_SINGLE;
            }
            if (display.getDisplaySize().getDisplayHeight() > Display.BW_160.getDisplaySize().getDisplayHeight() || display.getDisplaySize().getDisplayWidth() > Display.BW_160.getDisplaySize().getDisplayWidth()) {
                return DEFAULT_DOUBLE;
            }
        }
        return UNKNOWN;
    }

    public boolean isValid() {
        return this.valid;
    }

    public PowerStatus calculatePowerStatus(BatterySample batterySample) {
        if (this.isValid()) {
            double highLoadVoltage = batterySample.getHighLoadVoltage();
            if (highLoadVoltage <= this.getBatteryLimits().getBadLimit()) {
                return PowerStatus.BAD;
            }
            if (highLoadVoltage <= this.getBatteryLimits().getLowLimit()) {
                return PowerStatus.LOW;
            }
            return PowerStatus.GOOD;
        }
        return PowerStatus.UNKNOWN;
    }
}

