/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.battery;

public class BatterySample {
    private final double lowLoadVoltage;
    private final double highLoadVoltage;
    private final double adcTemperature;

    public static BatterySample fromBatterySample(int batterySampleValue) {
        double lowLoadVoltage = BatterySample.calculateAdcValue(BatterySample.getRawLowLoadVoltage(batterySampleValue));
        double highLoadVoltage = BatterySample.calculateAdcValue(BatterySample.getRawHighLoadVoltage(batterySampleValue));
        double adcTemperature = BatterySample.calculateAdcTemperature(BatterySample.getRawAdcTemperature(batterySampleValue));
        return new BatterySample(lowLoadVoltage, highLoadVoltage, adcTemperature);
    }

    public BatterySample(double lowLoadVoltage, double highLoadVoltage, double adcTemperature) {
        this.lowLoadVoltage = lowLoadVoltage;
        this.highLoadVoltage = highLoadVoltage;
        this.adcTemperature = adcTemperature;
    }

    public double getLowLoadVoltage() {
        return this.lowLoadVoltage;
    }

    public double getHighLoadVoltage() {
        return this.highLoadVoltage;
    }

    public double getAdcTemperature() {
        return this.adcTemperature;
    }

    private static double calculateAdcValue(int rawValue) {
        return (double)rawValue * 3.75 / 1024.0;
    }

    private static double calculateAdcTemperature(int rawAdcTemperature) {
        return ((double)rawAdcTemperature * 1250.0 / 1024.0 - 750.0) / 2.43;
    }

    private static int getRawLowLoadVoltage(int batterySampleValue) {
        return batterySampleValue >> 22 & 0x3FF;
    }

    private static int getRawHighLoadVoltage(int batterySampleValue) {
        return batterySampleValue >> 12 & 0x3FF;
    }

    private static int getRawAdcTemperature(int batterySampleValue) {
        return batterySampleValue >> 2 & 0x3FF;
    }

    public String toString() {
        return String.format("Battery sample: low-load=%.2f, high-load=%.2f, temperature=%.2f", this.getLowLoadVoltage(), this.getHighLoadVoltage(), this.getAdcTemperature());
    }
}

