/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.auxpage;

import at.mrdevelopment.esl.auxpage.AuxPageSource;
import at.mrdevelopment.toolkit.nfc.NFCUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.validator.routines.UrlValidator;

public class NDEFMessageURLSource
implements AuxPageSource {
    private static final UrlValidator VALIDATOR = new UrlValidator(new String[]{"http", "https"});
    private static final byte REVISION = 2;
    private static final int MAX_URL_LENGTH = 160;
    private final byte[] data;
    private final String urlString;

    public NDEFMessageURLSource(String urlString) throws MalformedURLException {
        this.urlString = urlString;
        if (urlString == null || urlString.isEmpty() || urlString.length() > 160) {
            throw new IllegalArgumentException(String.format("Invalid URL (max length: %d): %s", 160, urlString));
        }
        if (!VALIDATOR.isValid(urlString)) {
            throw new MalformedURLException(String.format("%s is not a valid URL", urlString));
        }
        try {
            URI uri = new URI(urlString);
            String scheme = uri.getScheme();
            boolean ssl = scheme != null && scheme.toLowerCase().equals("https");
            String path = uri.getSchemeSpecificPart().replaceFirst("//", "");
            byte[] ndefMessage = NFCUtils.convertToNdefMessage((String)path, (boolean)ssl);
            this.data = new byte[ndefMessage.length + 1];
            System.arraycopy(ndefMessage, 0, this.data, 1, ndefMessage.length);
            this.data[0] = (byte)ndefMessage.length;
        }
        catch (URISyntaxException exc) {
            throw new MalformedURLException(exc.getMessage());
        }
    }

    public String getURL() {
        return this.urlString;
    }

    @Override
    public byte getRevision() {
        return 2;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }
}

