/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class AccessPointWorkload {
    private final List<UUID> tasksToAbort;
    private final List<UUID> tasksToRemove;
    private final List<ExternalUpdateTask> scheduledUpdateTasks;
    private int scheduledUpdateTasksSize;

    public AccessPointWorkload() {
        this(new ArrayList<UUID>(), new ArrayList<UUID>(), new ArrayList<ExternalUpdateTask>(), 0);
    }

    private AccessPointWorkload(List<UUID> tasksToAbort, List<UUID> tasksToRemove, List<ExternalUpdateTask> scheduledUpdateTasks, int scheduledUpdateTasksSize) {
        this.tasksToAbort = tasksToAbort;
        this.tasksToRemove = tasksToRemove;
        this.scheduledUpdateTasks = scheduledUpdateTasks;
        this.scheduledUpdateTasksSize = scheduledUpdateTasksSize;
    }

    public static AccessPointWorkload merge(AccessPointWorkload first, AccessPointWorkload second) {
        HashSet<UUID> tasksToAbort = new HashSet<UUID>();
        HashSet<UUID> tasksToRemove = new HashSet<UUID>();
        ArrayList<ExternalUpdateTask> scheduledUpdateTasks = new ArrayList<ExternalUpdateTask>();
        int scheduledUpdateTasksSize = 0;
        tasksToAbort.addAll(first.tasksToAbort);
        tasksToRemove.addAll(first.tasksToRemove);
        scheduledUpdateTasks.addAll(first.scheduledUpdateTasks);
        scheduledUpdateTasksSize += first.getScheduledUpdateTaskSize();
        tasksToAbort.addAll(second.tasksToAbort);
        tasksToRemove.addAll(second.tasksToRemove);
        scheduledUpdateTasks.addAll(second.scheduledUpdateTasks);
        scheduledUpdateTasksSize += second.getScheduledUpdateTaskSize();
        Iterator iterator = scheduledUpdateTasks.iterator();
        while (iterator.hasNext()) {
            ExternalUpdateTask updateTask = (ExternalUpdateTask)iterator.next();
            UUID taskId = updateTask.getTaskId();
            boolean removedFromAbortRequests = tasksToAbort.remove(taskId);
            boolean removedFromRemoveRequests = tasksToRemove.remove(taskId);
            if (!removedFromAbortRequests && !removedFromRemoveRequests) continue;
            iterator.remove();
            scheduledUpdateTasksSize -= updateTask.getSize();
        }
        return new AccessPointWorkload(new ArrayList<UUID>(tasksToAbort), new ArrayList<UUID>(tasksToRemove), scheduledUpdateTasks, scheduledUpdateTasksSize);
    }

    public void scheduleTaskForAborting(UUID taskId) {
        this.tasksToAbort.add(taskId);
    }

    public void scheduleTaskForRemoval(UUID taskId) {
        this.tasksToRemove.add(taskId);
    }

    public void scheduleUpdateTask(ExternalUpdateTask updateTask) {
        this.scheduledUpdateTasksSize += updateTask.getSize();
        this.scheduledUpdateTasks.add(updateTask);
    }

    public List<UUID> getTasksToAbort() {
        return Collections.unmodifiableList(new ArrayList<UUID>(this.tasksToAbort));
    }

    public List<UUID> getTasksToRemove() {
        return Collections.unmodifiableList(new ArrayList<UUID>(this.tasksToRemove));
    }

    public List<ExternalUpdateTask> getScheduledUpdateTasks() {
        return Collections.unmodifiableList(new ArrayList<ExternalUpdateTask>(this.scheduledUpdateTasks));
    }

    public int getScheduledAbortRequestCount() {
        return this.tasksToAbort.size();
    }

    public int getScheduledRemoveRequestCount() {
        return this.tasksToRemove.size();
    }

    public int getScheduledUpdateTaskCount() {
        return this.scheduledUpdateTasks.size();
    }

    public int getScheduledUpdateTaskSize() {
        return this.scheduledUpdateTasksSize;
    }

    public boolean isEmpty() {
        return this.tasksToAbort.isEmpty() && this.tasksToRemove.isEmpty() && this.scheduledUpdateTasks.isEmpty();
    }

    public void clear() {
        this.tasksToAbort.clear();
        this.tasksToRemove.clear();
        this.scheduledUpdateTasks.clear();
        this.scheduledUpdateTasksSize = 0;
    }
}

