/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.admin.platform.EnvironmentPropertiesHelper;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.toolkit.Version;

public class AccessPointServiceStatus {
    private final ServiceStatus serviceStatus;

    public AccessPointServiceStatus(ServiceStatus serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    public ServiceStatus getServiceStatus() {
        return this.serviceStatus;
    }

    public String getDeviceModel() {
        String value = this.serviceStatus.getPropertyValue("device-model");
        return this.isValidString(value) ? value : "";
    }

    public String getAdapterName() {
        return this.serviceStatus.getPropertyValue("adapter-name");
    }

    public Boolean isAutoConfig() {
        String value = this.serviceStatus.getPropertyValue("auto-config");
        return this.isValidString(value) ? Boolean.valueOf(value) : null;
    }

    public boolean isThinAPModeEnabled() {
        String value = this.serviceStatus.getPropertyValue("thinap-mode");
        return this.isValidString(value) ? Boolean.valueOf(value) : false;
    }

    public boolean isOutboundModeEnabled() {
        String value = this.serviceStatus.getPropertyValue("outbound-mode");
        return this.isValidString(value) ? Boolean.valueOf(value) : false;
    }

    public String getApcAddress() {
        String value = this.serviceStatus.getPropertyValue("apc-address");
        return this.isValidString(value) ? value : "";
    }

    public int getApcPort() {
        String value = this.serviceStatus.getPropertyValue("apc-port");
        return this.isValidString(value) ? Integer.valueOf(value) : -1;
    }

    public String getBroadcastAddress() {
        return this.serviceStatus.getPropertyValue("broadcast");
    }

    public int getBuild() {
        String value = this.serviceStatus.getPropertyValue("build");
        return this.isValidString(value) ? Integer.valueOf(value) : 0;
    }

    public WirelessChannel getChannel() {
        String value = this.serviceStatus.getPropertyValue("channel");
        return this.isValidString(value) ? WirelessChannel.fromString((String)value) : null;
    }

    public String getServer() {
        EnvironmentProperties prop = EnvironmentPropertiesHelper.getProperties();
        String serverAddress = this.serviceStatus.getPropertyValue("server-hostname");
        if (prop != null) {
            return prop.getIPAddress().equals(serverAddress) ? "localhost" : serverAddress;
        }
        return serverAddress;
    }

    public String getDeviceType() {
        return this.serviceStatus.getPropertyValue("device-type");
    }

    public Version getFirmwareVersion() {
        String value = this.serviceStatus.getPropertyValue("firmware-version");
        return this.isValidString(value) ? Version.fromString((String)value) : null;
    }

    public int getHardwareRevision() {
        String value = this.serviceStatus.getPropertyValue("hardware-revision");
        return this.isValidString(value) ? Integer.valueOf(value).intValue() : this.getDeprecatedHardwareRevision();
    }

    private int getDeprecatedHardwareRevision() {
        String value = this.serviceStatus.getPropertyValue("hardware-version");
        return this.isValidString(value) ? Integer.valueOf(value) : 0;
    }

    public String getHostname() {
        return this.serviceStatus.getPropertyValue("hostname");
    }

    public int getAccessPointId() {
        String value = this.serviceStatus.getPropertyValue("id");
        return this.isValidString(value) ? Integer.valueOf(value) : 0;
    }

    public String getSerial() {
        return this.serviceStatus.getPropertyValue("serial");
    }

    public boolean hasValidRoamingTable() {
        String value = this.serviceStatus.getPropertyValue("roaming-table-valid");
        return this.isValidString(value) ? Boolean.valueOf(value) : false;
    }

    public int getPingIntervall() {
        return Integer.parseInt(this.serviceStatus.getPropertyValue("ping-interval").split(" ")[0]);
    }

    public int getTasksCount() {
        String value = this.serviceStatus.getPropertyValue("tasks");
        return this.isValidString(value) ? Integer.valueOf(value) : 0;
    }

    public int getTasksSize() {
        String value = this.serviceStatus.getPropertyValue("task-size");
        return this.isValidString(value) ? Integer.valueOf(value) : 0;
    }

    public Version getVersion() {
        String value = this.serviceStatus.getPropertyValue("version");
        return this.isValidString(value) ? Version.fromString((String)value) : null;
    }

    public ConnectionStatus getConnectionStatus() {
        String value = this.serviceStatus.getPropertyValue("status");
        return this.isValidString(value) ? ConnectionStatus.valueOf((String)value) : ConnectionStatus.UNKNOWN;
    }

    public boolean getProtocolTLSEnabled() {
        return this.serviceStatus.getBooleanValue("protocol-tls");
    }

    private boolean isValidString(String string) {
        return string != null && !string.isEmpty();
    }
}

