/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointAsyncRequestExecutionStrategy;
import at.mrdevelopment.esl.accesspoint.AccessPointDefaultRequestExecutionStrategy;
import at.mrdevelopment.esl.accesspoint.AccessPointDefaultRequestStrategy;
import at.mrdevelopment.esl.accesspoint.AccessPointReplyCallback;
import at.mrdevelopment.esl.accesspoint.AccessPointRequestExecutionStrategy;
import at.mrdevelopment.esl.accesspoint.AccessPointRequestFailedHandler;
import at.mrdevelopment.esl.accesspoint.AccessPointRequestStrategy;
import at.mrdevelopment.esl.accesspoint.AccessPointRequestStrategyFactory;
import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.admin.AccessPointConfigurationXMLSerializer;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AccessPointConfiguration;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.core.accesspoint.AccessPointProtocol;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.roaming.InternalRoamingTable;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.updatetask.UpdateTaskXMLSerializer;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.esl.xml.JoinRequestXMLSerializer;
import at.mrdevelopment.esl.xml.RoamingTableXMLSerializer;
import at.mrdevelopment.esl.xml.ServiceStatusXMLSerializer;
import at.mrdevelopment.esl.xml.WakeupStatisticXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.http.HttpServiceClient;
import at.mrdevelopment.toolkit.http.HttpServiceClientConfiguration;
import at.mrdevelopment.toolkit.http.IgnoreResponseHandler;
import at.mrdevelopment.toolkit.http.RequestFailedHandler;
import at.mrdevelopment.toolkit.http.ResponseHandler;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.w3c.dom.Document;

public class AccessPointServiceClient
implements AccessPointService {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointServiceClient.class);
    private final ServiceAddress serviceAddress;
    private final AccessPointConfigurationXMLSerializer xmlAccessPointConfiguration;
    private final HttpServiceClient httpServiceClient;
    private final WakeupStatisticXMLSerializer xmlStatistics;
    private final JoinRequestXMLSerializer xmlJoinRequests;
    private final UpdateTaskXMLSerializer xmlUpdateTasks;
    private final RoamingTableXMLSerializer xmlRoamingTable;
    private final ServiceStatusXMLSerializer xmlServiceStatus;
    private final XMLContentProducerFactory contentProducerFactory;
    private final AccessPointRequestExecutionStrategy executionStrategy;
    private int accessPointId;
    private final boolean ignoreAccessPointIdCheck;
    private AccessPointRequestStrategy requestStrategy = new AccessPointDefaultRequestStrategy();
    private DateTime lastAssignedLabelsQueryTime = null;
    private DateTime lastDiscoveredLabelsQueryTime = null;
    private boolean useOldSerialization = false;

    public AccessPointServiceClient(int accessPointId, ServiceAddress serviceAddress, HttpServiceClientConfiguration configuration, boolean ignoreAccessPointIdCheck, boolean useAsyncStrategy) throws InitializationException {
        this.accessPointId = accessPointId;
        this.serviceAddress = serviceAddress;
        this.ignoreAccessPointIdCheck = ignoreAccessPointIdCheck;
        this.httpServiceClient = new HttpServiceClient(serviceAddress.getHost(), serviceAddress.getPort(), serviceAddress.useSSL(), serviceAddress.getPath(), configuration, false);
        if (serviceAddress.hasCredentials()) {
            this.httpServiceClient.setCredentials(serviceAddress.getUsername(), serviceAddress.getPassword());
        }
        this.executionStrategy = useAsyncStrategy ? new AccessPointAsyncRequestExecutionStrategy() : new AccessPointDefaultRequestExecutionStrategy();
        this.xmlStatistics = new WakeupStatisticXMLSerializer();
        this.xmlJoinRequests = new JoinRequestXMLSerializer();
        this.xmlUpdateTasks = new UpdateTaskXMLSerializer();
        this.xmlRoamingTable = new RoamingTableXMLSerializer();
        this.xmlServiceStatus = new ServiceStatusXMLSerializer();
        this.xmlAccessPointConfiguration = new AccessPointConfigurationXMLSerializer();
        this.contentProducerFactory = XMLContentProducerFactory.newInstance();
    }

    public AccessPointServiceClient(int accessPointId, ServiceAddress serviceAddress, HttpServiceClientConfiguration configuration) throws InitializationException {
        this(accessPointId, serviceAddress, HttpServiceClientConfiguration.createDefaultConfiguration(), false, true);
    }

    public AccessPointServiceClient(int accessPointId, ServiceAddress serviceAddress, boolean ignoreAccessPointIdCheck) throws InitializationException {
        this(accessPointId, serviceAddress, HttpServiceClientConfiguration.createDefaultConfiguration(), ignoreAccessPointIdCheck, true);
    }

    public AccessPointServiceClient(int accessPointId, ServiceAddress serviceAddress, boolean ignoreAccessPointIdCheck, boolean useAsyncStrategy) throws InitializationException {
        this(accessPointId, serviceAddress, HttpServiceClientConfiguration.createDefaultConfiguration(), ignoreAccessPointIdCheck, useAsyncStrategy);
    }

    public AccessPointServiceClient(int accessPointId, ServiceAddress serviceAddress) throws InitializationException {
        this(accessPointId, serviceAddress, HttpServiceClientConfiguration.createDefaultConfiguration(), false, true);
    }

    @Override
    public int getAccessPointId() {
        return this.accessPointId;
    }

    @Override
    public ServiceAddress getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    public ServiceAddress getSoftwareUpdateServiceAddress() {
        return this.getServiceAddress();
    }

    @Override
    public void sendConfiguration(AccessPointConfiguration accessPointConfiguration) throws WebserviceException, SerializeException {
        Document document = this.xmlAccessPointConfiguration.toXML(accessPointConfiguration);
        HttpPost request = new HttpPost("/service/config/all.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
    }

    @Override
    public void sendRoamingTable(RoamingTable roamingTable) throws WebserviceException, SerializeException {
        logger.info("Sending roaming table with %d entries to access point %d", new Object[]{roamingTable.getSize(), this.accessPointId});
        Document document = this.xmlRoamingTable.toXML(roamingTable);
        HttpPost request = new HttpPost("/service/labels/assignment.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
    }

    @Override
    public void sendSoftwareUpdate(File file) throws WebserviceException {
        logger.info("Sending software update to access point");
        FileBody contentBodyFile = new FileBody(file, ContentType.MULTIPART_FORM_DATA);
        HttpEntity multipartEntity = MultipartEntityBuilder.create().addPart("file", (ContentBody)contentBodyFile).build();
        HttpPost request = new HttpPost("/service/config/software/upload.html");
        request.setEntity(multipartEntity);
        this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
    }

    public void shutdown() {
        this.httpServiceClient.close();
    }

    @Override
    public void queryServiceStatus(final AccessPointReplyCallback callback) {
        HttpGet request = new HttpGet("/service/status.xml");
        this.executionStrategy.execute(this.httpServiceClient, (HttpRequestBase)request, new ResponseHandler<ServiceStatus>(){

            public ServiceStatus handleResponse(HttpResponse response) throws SerializeException, IOException {
                InputStream inputStream = response.getEntity().getContent();
                ServiceStatus serviceStatus = AccessPointServiceClient.this.xmlServiceStatus.parseXML(inputStream);
                AccessPointServiceStatus accessPointServiceStatus = new AccessPointServiceStatus(serviceStatus);
                AccessPointServiceClient.this.loadRequestStrategy(accessPointServiceStatus);
                if (AccessPointServiceClient.this.ignoreAccessPointIdCheck || AccessPointServiceClient.this.accessPointId == accessPointServiceStatus.getAccessPointId()) {
                    AccessPointServiceClient.this.accessPointId = accessPointServiceStatus.getAccessPointId();
                    callback.processServiceStatus(AccessPointServiceClient.this, accessPointServiceStatus);
                } else {
                    logger.error("Queried AP is not expected. Expected AP = %d, queried AP: %d.", new Object[]{AccessPointServiceClient.this.accessPointId, accessPointServiceStatus.getAccessPointId()});
                }
                return serviceStatus;
            }
        }, new AccessPointRequestFailedHandler(this, callback));
    }

    private void loadRequestStrategy(AccessPointServiceStatus accessPointServiceStatus) {
        Version version = accessPointServiceStatus.getVersion();
        this.requestStrategy = AccessPointRequestStrategyFactory.getStrategyForVersion(version, this.httpServiceClient, this.contentProducerFactory);
    }

    @Override
    public void queryAssignedLabels(final AccessPointReplyCallback callback) {
        int seconds = this.getSecondsForQuery(this.lastAssignedLabelsQueryTime);
        String queryUrl = this.requestStrategy.getQueryAssignedLabelsUrl(seconds);
        HttpGet request = new HttpGet(queryUrl);
        this.executionStrategy.execute(this.httpServiceClient, (HttpRequestBase)request, new ResponseHandler<Collection<WakeupStatistic>>(){

            public Collection<WakeupStatistic> handleResponse(HttpResponse response) throws SerializeException, IOException {
                InputStream inputStream = response.getEntity().getContent();
                AccessPointServiceClient.this.lastAssignedLabelsQueryTime = DateTime.now();
                Collection receivedWakeups = AccessPointServiceClient.this.xmlStatistics.parseXML(inputStream);
                callback.processWakeupStatistics(receivedWakeups);
                return receivedWakeups;
            }
        }, new RequestFailedHandler(){

            public void requestFailed(Exception exception) {
                logger.warn(exception.getMessage());
                logger.logExceptionIfDebugEnabled((Throwable)exception);
                callback.failedToQueryAccessPoint(AccessPointServiceClient.this);
                callback.processWakeupStatistics(new ArrayList<WakeupStatistic>());
            }

            public void requestAborted() {
            }
        });
    }

    @Override
    public void queryDiscoveredLabels(final AccessPointReplyCallback callback) {
        int seconds = this.getSecondsForQuery(this.lastDiscoveredLabelsQueryTime);
        String queryUrl = this.requestStrategy.getQueryDiscoveredLabelsUrl(seconds);
        HttpGet request = new HttpGet(queryUrl);
        this.executionStrategy.execute(this.httpServiceClient, (HttpRequestBase)request, new ResponseHandler<Collection<JoinRequest>>(){

            public Collection<JoinRequest> handleResponse(HttpResponse response) throws SerializeException, IOException {
                InputStream inputStream = response.getEntity().getContent();
                AccessPointServiceClient.this.lastDiscoveredLabelsQueryTime = DateTime.now();
                Collection receivedJoinRequests = AccessPointServiceClient.this.xmlJoinRequests.parseXML(inputStream);
                callback.processJoinRequests(receivedJoinRequests);
                return receivedJoinRequests;
            }
        }, new RequestFailedHandler(){

            public void requestFailed(Exception exception) {
                logger.warn(exception.getMessage());
                logger.logExceptionIfDebugEnabled((Throwable)exception);
                callback.failedToQueryAccessPoint(AccessPointServiceClient.this);
                callback.processJoinRequests(new ArrayList<JoinRequest>());
            }

            public void requestAborted() {
            }
        });
    }

    @Override
    public void queryUpdateTasks(final AccessPointReplyCallback callback) throws DatasetException {
        String queryUrl = this.requestStrategy.getQueryUpdateTasksUrl();
        HttpGet request = new HttpGet(queryUrl);
        this.executionStrategy.execute(this.httpServiceClient, (HttpRequestBase)request, new ResponseHandler<Collection<ExternalUpdateTask>>(){

            public Collection<ExternalUpdateTask> handleResponse(HttpResponse response) throws SerializeException, IOException {
                InputStream inputStream = response.getEntity().getContent();
                List updateTasks = AccessPointServiceClient.this.xmlUpdateTasks.parseXML(inputStream);
                try {
                    callback.processUpdateTasks(AccessPointServiceClient.this.accessPointId, updateTasks);
                }
                catch (DatasetException exc) {
                    logger.warn("Error processing update tasks: %s", new Object[]{exc.getMessage()});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                }
                return updateTasks;
            }
        }, new RequestFailedHandler(){

            public void requestFailed(Exception exception) {
                logger.warn(exception.getMessage());
                logger.logExceptionIfDebugEnabled((Throwable)exception);
                callback.failedToQueryAccessPoint(AccessPointServiceClient.this);
                try {
                    callback.processUpdateTasks(AccessPointServiceClient.this.accessPointId, new ArrayList<ExternalUpdateTask>());
                }
                catch (DatasetException exc) {
                    logger.warn("Error processing update tasks: %s", new Object[]{exc.getMessage()});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                }
            }

            public void requestAborted() {
            }
        });
    }

    @Override
    public void queryLabelEvents(AccessPointReplyCallback callback) {
        List<LabelEvent> labelEvents = null;
        try {
            labelEvents = this.requestStrategy.queryLabelEvents(this.httpServiceClient);
        }
        catch (WebserviceException exc) {
            labelEvents = Collections.emptyList();
            logger.warn(exc.getMessage());
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            callback.failedToQueryAccessPoint(this);
        }
        callback.processLabelEvents(this.accessPointId, labelEvents);
    }

    protected int getSecondsForQuery(DateTime time) {
        return time != null ? Seconds.secondsBetween((ReadableInstant)time, (ReadableInstant)DateTime.now()).getSeconds() + 15 : 0;
    }

    public void setUseOldVersionXMLSerialization(boolean useOldSerialization) {
        this.useOldSerialization = useOldSerialization;
    }

    @Override
    public void sendAbortRequests(List<UUID> tasksToAbort) throws WebserviceException, SerializeException {
        if (!tasksToAbort.isEmpty()) {
            this.requestStrategy.abortTasks(this.httpServiceClient, tasksToAbort);
        }
    }

    @Override
    public void sendRemoveRequests(List<UUID> tasksToRemove) throws WebserviceException, SerializeException {
        if (!tasksToRemove.isEmpty()) {
            this.requestStrategy.removeTasks(this.httpServiceClient, tasksToRemove);
        }
    }

    @Override
    public void sendTasks(List<ExternalUpdateTask> updateTasks) throws WebserviceException, SerializeException {
        if (!updateTasks.isEmpty()) {
            Document document = this.xmlUpdateTasks.toXML(updateTasks, true, this.useOldSerialization);
            HttpPost request = new HttpPost("/service/tasks/add.xml");
            request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
            this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
        }
    }

    @Override
    public boolean isTaskTypeSupported(TaskType taskType) {
        return this.requestStrategy.isTaskTypeSupported(taskType);
    }

    @Override
    public AccessPointProtocol getProtocol() {
        return AccessPointProtocol.THICK;
    }

    @Override
    public void sendInternalRoamingTable(InternalRoamingTable roamingTable) {
    }
}

