/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.tasks;

import at.mrdevelopment.esl.auxpage.RawAuxPageSource;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.UpdateCreationException;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.core.security.Puk;
import at.mrdevelopment.esl.firmware.FileFirmwareSource;
import at.mrdevelopment.esl.firmware.FirmwareSource;
import at.mrdevelopment.esl.firmware.MemoryFirmwareSource;
import at.mrdevelopment.esl.flashing.BasicLED;
import at.mrdevelopment.esl.flashing.LEDColor;
import at.mrdevelopment.esl.flashing.LEDPattern;
import at.mrdevelopment.esl.flashing.LabelLED;
import at.mrdevelopment.esl.persistence.record.TaskRecord;
import at.mrdevelopment.esl.persistence.record.TransactionRecord;
import at.mrdevelopment.esl.tasks.AuxPageTask;
import at.mrdevelopment.esl.tasks.BinaryImageTask;
import at.mrdevelopment.esl.tasks.ErrorTask;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.FirmwareTask;
import at.mrdevelopment.esl.tasks.FlashingTask;
import at.mrdevelopment.esl.tasks.ForceChannelScanTask;
import at.mrdevelopment.esl.tasks.GetConfigTask;
import at.mrdevelopment.esl.tasks.InitializeTask;
import at.mrdevelopment.esl.tasks.NDEFMessageTask;
import at.mrdevelopment.esl.tasks.PingTask;
import at.mrdevelopment.esl.tasks.QueryCounterTask;
import at.mrdevelopment.esl.tasks.QuerySensorTask;
import at.mrdevelopment.esl.tasks.RebootTask;
import at.mrdevelopment.esl.tasks.RefreshDisplayTask;
import at.mrdevelopment.esl.tasks.RegisterLabelTask;
import at.mrdevelopment.esl.tasks.ResetAllCountersTask;
import at.mrdevelopment.esl.tasks.ResetCounterTask;
import at.mrdevelopment.esl.tasks.SetConfigTask;
import at.mrdevelopment.esl.tasks.SwitchPageTask;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.tasks.UnlockLabelTask;
import at.mrdevelopment.esl.tasks.UnregisterLabelTask;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.update.Update;
import at.mrdevelopment.esl.updatetask.LabelConfig;
import at.mrdevelopment.esl.updatetask.LabelCounter;
import at.mrdevelopment.esl.updatetask.LabelKeys;
import at.mrdevelopment.esl.updatetask.LabelSensor;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.FirmwareImage;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class UpdateStatusFactory {
    static ESLLogger logger = ESLLogger.getLogger(UpdateStatusFactory.class);

    public Update createRetry(Update referencedUpdate) throws SerializeException {
        UUID taskId = this.createTaskId();
        int retriesLeft = Math.max(0, referencedUpdate.getRetriesLeft() - 1);
        return Update.createRetry((TaskRecord)referencedUpdate.getTaskRecord(), (UUID)taskId, (int)retriesLeft, (int)referencedUpdate.getTransmissionRetryDelaySeconds(Config.getTransmissionRetryDelaySeconds()));
    }

    public Update createResend(TaskTransaction transaction, Update referencedUpdate) throws SerializeException {
        try {
            ExecutableTask task = this.createTask(referencedUpdate);
            return this.createUpdate(transaction, task);
        }
        catch (UpdateCreationException exc) {
            LabelId labelId = referencedUpdate.getLabelId();
            TaskPriority priority = referencedUpdate.getPriority();
            long externalId = referencedUpdate.getExternalId();
            ErrorTask task = new ErrorTask(labelId, priority, externalId, exc.getUpdateError());
            return this.createError(transaction, task);
        }
    }

    public Update createUpdate(TaskTransaction transaction, ExecutableTask task) throws SerializeException {
        TransactionRecord transactionRecord = (TransactionRecord)transaction;
        UUID taskId = this.createTaskId();
        return Update.createDelayed((TransactionRecord)transactionRecord, (ExecutableTask)task, (UUID)taskId, (int)Config.getTransmissionRetriesCount());
    }

    public Update createError(TaskTransaction transaction, ErrorTask task) throws SerializeException {
        TransactionRecord transactionRecord = (TransactionRecord)transaction;
        UUID taskId = this.createTaskId();
        return Update.createError((TransactionRecord)transactionRecord, (ErrorTask)task, (UUID)taskId, (UpdateError)task.getUpdateError());
    }

    private UUID createTaskId() {
        return UUID.randomUUID();
    }

    public ExecutableTask createTask(Update update) throws SerializeException, UpdateCreationException {
        LabelId labelId = update.getLabelId();
        TaskType taskType = update.getTaskType();
        TaskPriority priority = update.getPriority();
        long externalId = update.getExternalId();
        if (taskType == TaskType.REGISTER_LABEL) {
            String data = update.getData();
            Pin pin = RegisterLabelTask.parsePinFromData(data);
            Set<String> tags = RegisterLabelTask.parseTagsFromData(data);
            return new RegisterLabelTask(labelId, pin, tags, externalId, false);
        }
        if (taskType == TaskType.UNREGISTER_LABEL) {
            return new UnregisterLabelTask(labelId, externalId, false);
        }
        if (taskType == TaskType.UNLOCK_LABEL) {
            String data = update.getData();
            Puk puk = UnlockLabelTask.parsePukFromData((String)data);
            return new UnlockLabelTask(labelId, puk, priority, externalId, false);
        }
        if (taskType == TaskType.IMAGE || taskType == TaskType.PRELOAD_IMAGE) {
            BufferedImage image = update.getImage();
            Page page = update.getPage();
            boolean preload = taskType == TaskType.PRELOAD_IMAGE;
            return new BinaryImageTask(labelId, priority, externalId, false, image, page, preload);
        }
        if (taskType == TaskType.SWITCH_PAGE) {
            Page page = update.getPage();
            int duration = update.getData() != null ? Integer.valueOf(update.getData()) : 0;
            return new SwitchPageTask(labelId, priority, externalId, false, page, duration);
        }
        if (taskType == TaskType.REFRESH_DISPLAY) {
            return new RefreshDisplayTask(labelId, priority, externalId, false);
        }
        if (taskType == TaskType.RESET_ALL_COUNTERS) {
            return new ResetAllCountersTask(labelId, priority, externalId, false);
        }
        if (taskType == TaskType.PING) {
            return new PingTask(labelId, priority, externalId, false);
        }
        if (taskType == TaskType.FIRMWARE) {
            return new FirmwareTask(labelId, priority, externalId, false, this.firmwareDataToFirmwareSource(update.getTaskRecord().getData()));
        }
        if (taskType == TaskType.REBOOT) {
            return new RebootTask(labelId, priority, externalId, false);
        }
        if (taskType == TaskType.QUERY_COUNTER) {
            return new QueryCounterTask(labelId, priority, externalId, false, Collections2.transform((Collection)Lists.newArrayList((Object[])update.getData().split(";")), (Function)new Function<String, LabelCounter>(){

                public LabelCounter apply(String labelData) {
                    return LabelCounter.fromId((int)Integer.valueOf(labelData));
                }
            }));
        }
        if (taskType == TaskType.RESET_COUNTER) {
            return new ResetCounterTask(labelId, priority, externalId, false, Collections2.transform((Collection)Lists.newArrayList((Object[])update.getData().split(";")), (Function)new Function<String, LabelCounter>(){

                public LabelCounter apply(String labelData) {
                    return LabelCounter.fromId((int)Integer.valueOf(labelData));
                }
            }));
        }
        if (taskType == TaskType.RESET_ALL_COUNTERS) {
            return new ResetAllCountersTask(labelId, priority, externalId, false);
        }
        if (taskType == TaskType.QUERY_SENSOR) {
            return new QuerySensorTask(labelId, priority, externalId, false, Collections2.transform((Collection)Lists.newArrayList((Object[])update.getData().split(";")), (Function)new Function<String, LabelSensor>(){

                public LabelSensor apply(String labelData) {
                    return LabelSensor.fromId((int)Integer.valueOf(labelData));
                }
            }));
        }
        if (taskType == TaskType.GET_CONFIG) {
            return new GetConfigTask(labelId, priority, externalId, false, Collections2.transform((Collection)Lists.newArrayList((Object[])update.getData().split(";")), (Function)new Function<String, LabelConfig>(){

                public LabelConfig apply(String labelData) {
                    return LabelConfig.fromId((int)Integer.valueOf(labelData));
                }
            }));
        }
        if (taskType == TaskType.SET_CONFIG) {
            String[] split;
            HashMap<LabelConfig, Integer> config = new HashMap<LabelConfig, Integer>();
            for (String data : split = update.getData().split(";")) {
                String[] configSplit = data.split("=");
                if (configSplit.length != 2) continue;
                config.put(LabelConfig.fromId((int)Integer.valueOf(configSplit[0])), Integer.valueOf(configSplit[1]));
            }
            return new SetConfigTask(labelId, priority, externalId, false, config);
        }
        if (taskType == TaskType.REBOOT) {
            return new RebootTask(labelId, priority, externalId, false);
        }
        if (taskType == TaskType.FORCE_CHANNEL_SCAN) {
            boolean scanAllChannels = true;
            if (update.hasData()) {
                scanAllChannels = Boolean.valueOf(update.getData());
            }
            return new ForceChannelScanTask(labelId, priority, externalId, false, scanAllChannels);
        }
        if (taskType == TaskType.PROGRAM_KEYS) {
            String data = update.getData();
            Map split = Splitter.on((String)";").withKeyValueSeparator("|").split((CharSequence)data);
            HashMap keys = new HashMap();
            for (Map.Entry entry : split.entrySet()) {
                keys.put(LabelKeys.fromId((int)Integer.valueOf((String)entry.getKey())), entry.getValue());
            }
            return new InitializeTask(labelId, priority, externalId, false, keys);
        }
        if (taskType == TaskType.FLASHING) {
            String data = update.getData();
            Map split = Splitter.on((String)";").withKeyValueSeparator("=").split((CharSequence)data);
            String typeIdentifier = (String)split.get("type");
            if (typeIdentifier != null && typeIdentifier.equals(BasicLED.class.getSimpleName())) {
                int color = Integer.valueOf((String)split.get("color"));
                int pattern = Integer.valueOf((String)split.get("pattern"));
                int duration = Integer.valueOf((String)split.get("durationInMinutes"));
                int count = Integer.valueOf((String)split.get("repeatCount"));
                BasicLED led = new BasicLED(LEDColor.fromValue((int)color), LEDPattern.fromValue((int)pattern), duration, count);
                return new FlashingTask(labelId, priority, externalId, false, (LabelLED)led);
            }
        } else {
            if (taskType == TaskType.AUX_PAGE) {
                String data = update.getData();
                String[] split = StringUtils.split((String)data);
                if (split == null || split.length != 2) {
                    throw new SerializeException("Could not create aux page task: Invalid data", new Object[0]);
                }
                byte[] revisionArray = DatatypeConverter.parseHexBinary((String)split[0]);
                if (revisionArray.length != 1) {
                    throw new SerializeException("Could not create aux page task: Invalid revision", new Object[0]);
                }
                byte revision = revisionArray[0];
                byte[] auxData = DatatypeConverter.parseHexBinary((String)split[1]);
                RawAuxPageSource auxPageSource = new RawAuxPageSource(revision, auxData);
                return new AuxPageTask(labelId, priority, externalId, false, auxPageSource);
            }
            if (taskType == TaskType.NDEF_MESSAGE) {
                String ndefUrl = update.getData();
                try {
                    return new NDEFMessageTask(labelId, priority, externalId, false, ndefUrl);
                }
                catch (MalformedURLException exc) {
                    throw new SerializeException((Throwable)exc);
                }
            }
        }
        throw new UpdateCreationException(UpdateError.ERROR_CODE_UNSUPPORTED_TASK);
    }

    private FirmwareSource firmwareDataToFirmwareSource(String data) {
        if (FilenameUtils.isExtension((String)data, (String)"xml") || FilenameUtils.isExtension((String)data, (String)"hex")) {
            return new FileFirmwareSource(data);
        }
        return new MemoryFirmwareSource(FirmwareImage.decode((String)data));
    }
}

