/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.tasks;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.TagUtils;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.tasks.LabelMaintenanceTask;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class RegisterLabelTask
extends LabelMaintenanceTask {
    private final Pin pin;
    private final Set<String> tags;

    public RegisterLabelTask(LabelId labelId, Pin pin, Set<String> tags, long externalId, boolean replaceWaitingTasks) {
        super(labelId, TaskPriority.NORMAL, externalId, replaceWaitingTasks);
        this.pin = pin;
        this.tags = new HashSet<String>(tags);
    }

    public TaskType getTaskType() {
        return TaskType.REGISTER_LABEL;
    }

    public String getData() {
        if (this.pin == null && this.tags.isEmpty()) {
            return null;
        }
        return (this.pin != null ? this.pin.toBase64() : "") + ":" + TagUtils.toString(this.tags);
    }

    public Pin getPin() {
        return this.pin;
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public static Set<String> parseTagsFromData(String data) {
        if (Strings.isNullOrEmpty((String)data)) {
            return Collections.emptySet();
        }
        return TagUtils.parse((String)StringUtils.substringAfter((String)data, (String)":"));
    }

    public static Pin parsePinFromData(String data) {
        if (Strings.isNullOrEmpty((String)data)) {
            return null;
        }
        return RegisterLabelTask.parsePinFromPinSubstring(StringUtils.substringBefore((String)data, (String)":"));
    }

    private static Pin parsePinFromPinSubstring(String data) {
        if (Strings.isNullOrEmpty((String)data)) {
            return null;
        }
        return Pin.fromBase64((String)data);
    }
}

