/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.usb;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.imagotag.ReinitConfigHolder;
import at.mrdevelopment.esl.server.provisioning.imagotag.ReinitFields;
import at.mrdevelopment.esl.server.provisioning.usb.CommonConfigHolder;
import java.util.Collections;

public class USBModuleSettings
implements ModuleSpecificSettings {
    private final CommonConfigHolder serverSettings;
    private final ReinitConfigHolder reinitSettings;
    private boolean reinitSettingsChanged;
    private boolean isDiscoveryEnabled;

    public USBModuleSettings() {
        boolean thinModeEnabled = Config.isAccessPointUseThinMode();
        this.serverSettings = new CommonConfigHolder(thinModeEnabled);
        this.reinitSettings = new ReinitConfigHolder(thinModeEnabled);
        this.reinitSettingsChanged = false;
        this.isDiscoveryEnabled = Config.isListenForAccessPointBroadcastEnabled();
    }

    @Override
    public boolean isDiscoveryEnabled() {
        return this.isDiscoveryEnabled;
    }

    @Override
    public void calculateDifferences(ModuleSpecificSettings other) {
        if (other != null) {
            USBModuleSettings temp = (USBModuleSettings)other;
            this.reinitSettingsChanged = this.reinitSettings.isDifferentFrom(temp.reinitSettings, Collections.<ConfigField>emptyList());
        } else {
            this.reinitSettingsChanged = false;
        }
    }

    @Override
    public boolean connectionSettingsChanged() {
        return false;
    }

    @Override
    public boolean commonSettingsChanged() {
        return false;
    }

    public CommonConfigHolder getServerSettings() {
        return this.serverSettings;
    }

    @Override
    public boolean accessPointsRequireReinit() {
        return this.reinitSettingsChanged;
    }

    @Override
    public boolean thinModeEnabled() {
        return this.reinitSettings.get(ReinitFields.USE_THIN_MODE).getBoolValue();
    }
}

