/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.usb;

import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionMode;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.TargetConfigValidity;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.ThinSettings;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.usb.CommonFields;
import at.mrdevelopment.esl.server.provisioning.usb.USBModuleSettings;

public class USBDecisionLogicModule
implements DecisionLogicModule {
    private USBModuleSettings settings;

    @Override
    public void receive(ModuleSpecificSettings settings) {
        this.settings = (USBModuleSettings)settings;
    }

    @Override
    public boolean isUpdateApplicable(BasicConfigHolder configUpdateGoal, BaseExtConfigHolder currentConfig) {
        return false;
    }

    @Override
    public boolean likelyHappenedAfterLastUpdate(long lastUpdateTime, BaseExtConfigHolder newCurrentConfig) {
        return false;
    }

    @Override
    public TargetConfigValidity getValidity(BasicConfigHolder targetConfig, DecisionMode mode) {
        if (!targetConfig.isSet(BasicFields.AP_ID)) {
            return TargetConfigValidity.NOT_VALID;
        }
        if (mode == DecisionMode.CENTRALIZED) {
            return TargetConfigValidity.NOT_VALID;
        }
        if (targetConfig.allNonApIdFieldsNotSet()) {
            return TargetConfigValidity.MANUAL_ID_ONLY;
        }
        if (targetConfig.isSet(BasicFields.IP_ADDRESS) && targetConfig.isSet(BasicFields.PORT)) {
            return TargetConfigValidity.MANUAL_BASIC;
        }
        return TargetConfigValidity.NOT_VALID;
    }

    @Override
    public boolean canComeOnlineWithCurrentSituation(BasicConfigHolder targetConfig, BaseExtConfigHolder providedConfig) {
        return false;
    }

    @Override
    public boolean didAuthenticationFail(BaseExtConfigHolder providedConfig) {
        return false;
    }

    @Override
    public boolean doWeTryInit(BaseExtConfigHolder providedConfig) {
        return false;
    }

    @Override
    public boolean isRfModuleWorking(BaseExtConfigHolder providedConfig) {
        return true;
    }

    @Override
    public boolean commonSettingsChanged() {
        return this.settings.commonSettingsChanged();
    }

    @Override
    public boolean isPasswordChangeRequired(BaseExtConfigHolder providedConfig) {
        return false;
    }

    @Override
    public boolean isInitAllowed(long lastInitTime) {
        return false;
    }

    @Override
    public boolean accessPointsRequireReinit() {
        return this.settings.accessPointsRequireReinit();
    }

    @Override
    public boolean isOperationModeChangeRequired(ModuleSpecificSettings settings, BaseExtConfigHolder currentConfig) {
        return false;
    }

    @Override
    public boolean isOperationModeChangeSupported(ModuleSpecificSettings settings, AccessPointInfo apInfo) {
        return false;
    }

    @Override
    public ThinSettings getThinConfig() {
        ThinSettings thinConfig = new ThinSettings();
        thinConfig.setThinModeEnabled(this.settings.thinModeEnabled());
        thinConfig.setOutboundModeEnabled(this.settings.getServerSettings().get(CommonFields.USE_OUTBOUND_MODE).getBoolValue());
        return thinConfig;
    }

    @Override
    public boolean isOutboundModeSupported(AccessPointInfo apInfo) {
        return false;
    }

    @Override
    public boolean isTLSSupported(AccessPointInfo apInfo) {
        return false;
    }

    @Override
    public boolean hasTLSConfigChanged(ModuleSpecificSettings settings, BaseExtConfigHolder currentConfig) {
        return false;
    }
}

