/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.usb;

import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.server.DiscoveredAccessPointsHolder;
import at.mrdevelopment.esl.server.provisioning.AccessPointModulesProvider;
import at.mrdevelopment.esl.server.provisioning.SettingsCreator;
import at.mrdevelopment.esl.server.provisioning.configuration.ConfigurationModule;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.discovery.DiscoveryModule;
import at.mrdevelopment.esl.server.provisioning.service.ServiceModule;
import at.mrdevelopment.esl.server.provisioning.simulated.SimulatedSoftwareUpdateModule;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.SoftwareUpdateModule;
import at.mrdevelopment.esl.server.provisioning.usb.USBConfigurationModule;
import at.mrdevelopment.esl.server.provisioning.usb.USBDecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.usb.USBDiscoveryModule;
import at.mrdevelopment.esl.server.provisioning.usb.USBServiceModule;
import at.mrdevelopment.esl.server.provisioning.usb.USBSettingsCreator;

public class USBAccessPointModulesProvider
implements AccessPointModulesProvider {
    private final USBConfigurationModule configurationModule = new USBConfigurationModule();
    private final USBDiscoveryModule discoveryModule;
    private final USBDecisionLogicModule decisionLogicModule;
    private final USBServiceModule serviceModule;
    private final USBSettingsCreator settingsCreator;
    private final SimulatedSoftwareUpdateModule softwareUpdateModule;

    public USBAccessPointModulesProvider(DiscoveredAccessPointsHolder discoveredImagoAPs) {
        this.discoveryModule = new USBDiscoveryModule(discoveredImagoAPs);
        this.decisionLogicModule = new USBDecisionLogicModule();
        this.serviceModule = new USBServiceModule();
        this.settingsCreator = new USBSettingsCreator();
        this.softwareUpdateModule = new SimulatedSoftwareUpdateModule();
    }

    @Override
    public AccessPointType getAccessPointType() {
        return AccessPointType.USB_AP;
    }

    @Override
    public DiscoveryModule getDiscoveryModule() {
        return this.discoveryModule;
    }

    @Override
    public ConfigurationModule getConfigurationModule() {
        return this.configurationModule;
    }

    @Override
    public DecisionLogicModule getDecisioLogicModule() {
        return this.decisionLogicModule;
    }

    @Override
    public ServiceModule getServiceModule() {
        return this.serviceModule;
    }

    @Override
    public SettingsCreator getSettingsCreator() {
        return this.settingsCreator;
    }

    @Override
    public SoftwareUpdateModule getSoftwareUpdateModule() {
        return this.softwareUpdateModule;
    }
}

