/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.situation;

import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.NoTransaction;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.server.provisioning.configuration.OperationResult;
import at.mrdevelopment.esl.server.provisioning.configuration.SuccessState;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.TargetConfigValidity;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.ThinSettings;
import at.mrdevelopment.esl.server.provisioning.situation.AccessPointConfigSituation;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class OperationModeSituation {
    private static final ESLLogger logger = ESLLogger.getLogger(OperationModeSituation.class);
    private static final long CHANGE_REQUEST_MIN_TIME_DIFF_IN_MS = 60000L;
    private static final long CHANGE_REQUEST_MAX_TIME_DIFF_IN_MS = 1200000L;
    private static final long MIN_ONLINE_TIME_BEFORE_RESET_IN_MS = 120000L;
    private final AccessPointConfigSituation situation;
    private final AccessPointInfoDataset infoDataset;
    private long lastChangeRequestTime;
    private long currentChangeRequestTimeDiffInMs;
    private short changeRequestExecutionCounter;
    private long onlineSinceTime;
    private boolean firstTimeWithoutCurrentConfiguration;
    private boolean timesReset;

    public OperationModeSituation(AccessPointConfigSituation configSituation, AccessPointInfoDataset infoDataset) {
        this.situation = configSituation;
        this.infoDataset = infoDataset;
        this.firstTimeWithoutCurrentConfiguration = true;
        this.resetForSpecialSituationHandling();
    }

    private void resetForSpecialSituationHandling() {
        this.onlineSinceTime = -1L;
        this.changeRequestExecutionCounter = 0;
        this.currentChangeRequestTimeDiffInMs = 60000L;
        this.lastChangeRequestTime = 0L;
        this.timesReset = false;
    }

    private boolean isOnline(AccessPointInfo info) {
        return info.isOnline();
    }

    private void executeOperationModeUpdate(ThinSettings newSettings) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastChangeRequestTime > this.currentChangeRequestTimeDiffInMs) {
            OperationResult result = this.situation.modules.getConfig().changeOperationMode(this.situation.modules.getLatestSettings(), this.situation.getTargetConfig());
            if (result.getState() == SuccessState.SUCCESSFUL) {
                logger.info("Situation update successful - new mode = %b", new Object[]{newSettings.isThinModeEnabled()});
            } else {
                logger.info("Situation update failed - current mode = %b", new Object[]{newSettings.isThinModeEnabled()});
            }
            this.lastChangeRequestTime = currentTime;
            this.changeRequestExecutionCounter = (short)(this.changeRequestExecutionCounter + 1);
            if (this.changeRequestExecutionCounter % 3 == 0) {
                this.currentChangeRequestTimeDiffInMs = this.currentChangeRequestTimeDiffInMs < 1200000L ? (this.currentChangeRequestTimeDiffInMs += 60000L) : 1200000L;
                logger.info("Current change request time diff in ms: %d", new Object[]{this.currentChangeRequestTimeDiffInMs});
                this.changeRequestExecutionCounter = 0;
            }
            this.timesReset = false;
            this.onlineSinceTime = -1L;
        } else {
            logger.info("Not executing operation mode update for = %d, due to time constraints.", new Object[]{this.situation.getApId()});
        }
    }

    public void operationModeUpdate() {
        if (this.situation.isTargetConfigurationPresent()) {
            AccessPointInfo apInfo = null;
            try {
                apInfo = this.infoDataset.queryById((long)this.situation.getApId(), (Transaction<?>)NoTransaction.get());
                if (apInfo == null) {
                    return;
                }
            }
            catch (Exception e) {
                logger.logException((Throwable)e);
            }
            if (this.situation.modules.getDecisionLogic().isOperationModeChangeSupported(this.situation.modules.getLatestSettings(), apInfo)) {
                if (this.situation.getTargetConfigurationValidity() == TargetConfigValidity.MANUAL_BASIC && !this.situation.isCurrentConfigurationPresent()) {
                    boolean tlsConfigChanged;
                    boolean isTLSSupported;
                    if (!this.firstTimeWithoutCurrentConfiguration) {
                        this.firstTimeWithoutCurrentConfiguration = false;
                        this.resetForSpecialSituationHandling();
                        if (logger.isInfoEnabled()) {
                            logger.info("Init. special situation for = %d.", new Object[]{this.situation.getApId()});
                        }
                    }
                    ThinSettings thinConfig = this.situation.modules.getDecisionLogic().getThinConfig();
                    boolean isOutboundModeSupported = this.situation.modules.getDecisionLogic().isOutboundModeSupported(apInfo);
                    MatchResult matchResult = new MatchResult(apInfo, isOutboundModeSupported, thinConfig, isTLSSupported = this.situation.modules.getDecisionLogic().isTLSSupported(apInfo), tlsConfigChanged = this.situation.modules.getDecisionLogic().hasTLSConfigChanged(this.situation.modules.getLatestSettings(), this.situation.currentConfiguration));
                    if (matchResult.isMatching()) {
                        if (!this.isOnline(apInfo)) {
                            this.executeOperationModeUpdate(thinConfig);
                        } else if (!this.timesReset) {
                            long currentTime = System.currentTimeMillis();
                            if (this.onlineSinceTime == -1L) {
                                this.onlineSinceTime = currentTime;
                                logger.info("Detected AP %d as online, set onlineSinceTime.", new Object[]{this.situation.getApId()});
                            } else if (currentTime - this.onlineSinceTime > 120000L) {
                                this.onlineSinceTime = -1L;
                                this.changeRequestExecutionCounter = 0;
                                this.currentChangeRequestTimeDiffInMs = 60000L;
                                this.lastChangeRequestTime = 0L;
                                this.timesReset = true;
                                logger.info("AP %d online for long enough resetting logic!", new Object[]{this.situation.getApId()});
                            }
                        }
                    } else if (isOutboundModeSupported) {
                        this.executeOperationModeUpdate(thinConfig);
                    } else if (!matchResult.isThinModeMatching()) {
                        this.executeOperationModeUpdate(thinConfig);
                    } else if (tlsConfigChanged) {
                        this.executeOperationModeUpdate(thinConfig);
                    }
                } else if (this.situation.isCurrentConfigurationPresent()) {
                    this.firstTimeWithoutCurrentConfiguration = true;
                    if (this.situation.modules.getDecisionLogic().isOperationModeChangeRequired(this.situation.modules.getLatestSettings(), this.situation.currentConfiguration)) {
                        OperationResult result = this.situation.modules.getConfig().changeOperationMode(this.situation.modules.getLatestSettings(), this.situation.currentConfiguration);
                        if (result.getState() == SuccessState.SUCCESSFUL) {
                            this.situation.currentConfiguration.customOvertake(result.getExtHolder());
                        }
                        logger.info("Operation mode change was: %s.", new Object[]{result.getState().name()});
                    } else {
                        logger.debug("OperationMode change was not required for: %d.", new Object[]{this.situation.getApId()});
                    }
                }
            }
        }
    }

    class MatchResult {
        private boolean matching;
        private boolean thinModeMatching;

        MatchResult(AccessPointInfo info, boolean outboundModeSupported, ThinSettings newSettings, boolean isTLSSupported, boolean hasTLSConfigChanged) {
            AccessPointServiceStatus ss = info.getServiceStatus();
            this.thinModeMatching = ss.isThinAPModeEnabled() == newSettings.isThinModeEnabled();
            boolean bl = this.matching = this.thinModeMatching && ss.isOutboundModeEnabled() == newSettings.isOutboundModeEnabled();
            if (outboundModeSupported) {
                boolean bl2 = this.matching = this.matching && ss.getApcAddress().equals(newSettings.getApcAddress()) && ss.getApcPort() == newSettings.getApcPort();
            }
            if (isTLSSupported) {
                this.matching = this.matching && !hasTLSConfigChanged;
            }
        }

        boolean isMatching() {
            return this.matching;
        }

        boolean isThinModeMatching() {
            return this.thinModeMatching;
        }
    }
}

