/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.situation;

import at.mrdevelopment.esl.server.provisioning.AccessPointTypeModules;
import at.mrdevelopment.esl.server.provisioning.configuration.OperationResult;
import at.mrdevelopment.esl.server.provisioning.configuration.SuccessState;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomFields;
import at.mrdevelopment.esl.server.provisioning.situation.AccessPointConfigSituation;
import at.mrdevelopment.esl.server.provisioning.situation.InitResult;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class InitHandler {
    private static final ESLLogger logger = ESLLogger.getLogger(InitHandler.class);
    private AccessPointConfigSituation situation;

    InitHandler(AccessPointConfigSituation situation) {
        this.situation = situation;
    }

    public InitResult perform() {
        InitResult initResult = InitResult.SUCCESS;
        AccessPointTypeModules mods = this.situation.modules();
        if (mods.getDecisionLogic().didAuthenticationFail(this.situation.getCurrentConfig())) {
            if (mods.getDecisionLogic().isInitAllowed(this.situation.lastInitTime())) {
                if (mods.getDecisionLogic().doWeTryInit(this.situation.getCurrentConfig())) {
                    OperationResult result = mods.getConfig().initAccessPoint(this.situation.getCurrentConfig());
                    if (result.getState() != SuccessState.NOT_SUCCESSFUL) {
                        this.situation.getCurrentConfig().customOvertake(result.getExtHolder());
                    } else {
                        initResult = InitResult.FAILED;
                    }
                    this.situation.updateLastInitTime();
                } else if (mods.getDecisionLogic().isPasswordChangeRequired(this.situation.getCurrentConfig())) {
                    OperationResult result = mods.getConfig().changePassword(this.situation.getCurrentConfig());
                    if (result.getState() != SuccessState.NOT_SUCCESSFUL) {
                        this.situation.getCurrentConfig().set(LancomFields.AUTHENTICATION_SUCCESSFUL, true);
                    } else {
                        initResult = InitResult.FAILED;
                    }
                    this.situation.updateLastInitTime();
                } else {
                    initResult = InitResult.FAILED;
                }
            } else {
                logger.info("AP init was not allowed for AP = %d.", new Object[]{this.situation.getCurrentConfig().getBasicConfig().getApId()});
            }
        } else if (!mods.getDecisionLogic().didAuthenticationFail(this.situation.getCurrentConfig()) && !mods.getDecisionLogic().isRfModuleWorking(this.situation.getCurrentConfig())) {
            OperationResult result = mods.getConfig().turnOnRfModule(this.situation.getCurrentConfig());
            if (result.getState() != SuccessState.NOT_SUCCESSFUL) {
                this.situation.getCurrentConfig().customOvertake(result.getExtHolder());
            } else {
                initResult = InitResult.FAILED;
            }
        } else {
            initResult = InitResult.NOT_NEEDED;
        }
        return initResult;
    }
}

