/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.simulated;

import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionMode;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.TargetConfigValidity;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.ThinSettings;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.simulated.SimulatedModuleSettings;

public class SimulatedDecisionLogicModule
implements DecisionLogicModule {
    private final boolean ignoreSettings;
    private final boolean thinModeEnabled;
    private SimulatedModuleSettings settings;

    public SimulatedDecisionLogicModule(boolean thinModeEnabled, boolean ignoreSettings) {
        this.ignoreSettings = ignoreSettings;
        this.thinModeEnabled = thinModeEnabled;
    }

    @Override
    public void receive(ModuleSpecificSettings settings) {
        if (!this.ignoreSettings) {
            this.settings = (SimulatedModuleSettings)settings;
        }
    }

    @Override
    public boolean isUpdateApplicable(BasicConfigHolder configUpdateGoal, BaseExtConfigHolder currentConfig) {
        return false;
    }

    @Override
    public boolean likelyHappenedAfterLastUpdate(long lastUpdateTime, BaseExtConfigHolder newCurrentConfig) {
        return false;
    }

    @Override
    public TargetConfigValidity getValidity(BasicConfigHolder targetConfig, DecisionMode mode) {
        if (!targetConfig.isSet(BasicFields.AP_ID)) {
            return TargetConfigValidity.NOT_VALID;
        }
        if (mode == DecisionMode.CENTRALIZED) {
            return TargetConfigValidity.NOT_VALID;
        }
        if (targetConfig.allNonApIdFieldsNotSet()) {
            return TargetConfigValidity.MANUAL_ID_ONLY;
        }
        if (targetConfig.isSet(BasicFields.IP_ADDRESS) && targetConfig.isSet(BasicFields.PORT)) {
            return TargetConfigValidity.MANUAL_BASIC;
        }
        return TargetConfigValidity.NOT_VALID;
    }

    @Override
    public boolean canComeOnlineWithCurrentSituation(BasicConfigHolder targetConfig, BaseExtConfigHolder providedConfig) {
        return true;
    }

    @Override
    public boolean didAuthenticationFail(BaseExtConfigHolder providedConfig) {
        return false;
    }

    @Override
    public boolean doWeTryInit(BaseExtConfigHolder providedConfig) {
        return false;
    }

    @Override
    public boolean isRfModuleWorking(BaseExtConfigHolder providedConfig) {
        return true;
    }

    @Override
    public boolean commonSettingsChanged() {
        return false;
    }

    @Override
    public boolean isPasswordChangeRequired(BaseExtConfigHolder providedConfig) {
        return false;
    }

    @Override
    public boolean isInitAllowed(long lastInitTime) {
        return false;
    }

    @Override
    public boolean accessPointsRequireReinit() {
        return this.ignoreSettings ? false : this.settings.accessPointsRequireReinit();
    }

    @Override
    public boolean isOperationModeChangeRequired(ModuleSpecificSettings settings, BaseExtConfigHolder currentConfig) {
        return false;
    }

    @Override
    public boolean isOperationModeChangeSupported(ModuleSpecificSettings settings, AccessPointInfo apInfo) {
        return false;
    }

    @Override
    public ThinSettings getThinConfig() {
        ThinSettings config = new ThinSettings();
        if (this.ignoreSettings) {
            config.setThinModeEnabled(this.thinModeEnabled);
        } else {
            config.setThinModeEnabled(this.settings.thinModeEnabled());
        }
        return config;
    }

    @Override
    public boolean isOutboundModeSupported(AccessPointInfo apInfo) {
        return false;
    }

    @Override
    public boolean isTLSSupported(AccessPointInfo apInfo) {
        return false;
    }

    @Override
    public boolean hasTLSConfigChanged(ModuleSpecificSettings settings, BaseExtConfigHolder currentConfig) {
        return false;
    }
}

