/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.message;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;

public class AccessPointQueryById
extends DefaultDatasetQuery<AccessPointInfo, Void> {
    private final ConcurrentSkipListSet<Integer> apIds = new ConcurrentSkipListSet();

    public AccessPointQueryById(Dataset<AccessPointInfo> dataset, String url) {
        super(dataset, url, Void.class);
    }

    public void addApId(Integer apId) {
        this.apIds.add(apId);
    }

    public void removeApId(Integer apId) {
        this.apIds.remove(apId);
    }

    public void removeAllApIds() {
        this.apIds.clear();
    }

    @Override
    protected List<AccessPointInfo> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        ArrayList<AccessPointInfo> apsOfInterest = new ArrayList<AccessPointInfo>();
        for (AccessPointInfo accessPointInfo : this.dataset.queryAll(transaction)) {
            if (!this.apIds.contains(accessPointInfo.getAccessPointId())) continue;
            apsOfInterest.add(accessPointInfo);
        }
        return Collections.unmodifiableList(apsOfInterest);
    }
}

