/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.lancom;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.util.AccessPointUpdate;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomConfigHolder;
import at.mrdevelopment.esl.server.provisioning.service.ServiceModule;
import at.mrdevelopment.esl.server.provisioning.situation.AccessPointConfigSituation;

public class LancomServiceModule
implements ServiceModule {
    @Override
    public void init(boolean sslEnabled) {
    }

    @Override
    public void makeAccessPointServiceGoOffline(AccessPointConfigSituation situation, AccessPointInfoDataset infoDataset, EnvironmentProperties env) {
        AccessPointUpdate.Builder builder = new AccessPointUpdate.Builder();
        builder.accessPointId(situation.getApId()).serviceAddress(situation.createServiceAddress(env));
        builder.isPermanentlyOffline(true).serviceToBeInitialized(false).autoConfig(situation.canUpdate());
        builder.thinMode(situation.isThinModeEnabled());
        infoDataset.updateAccessPoint(builder.build());
    }

    @Override
    public ServiceAddress createServiceAddress(BaseExtConfigHolder configHolder) {
        LancomConfigHolder config = (LancomConfigHolder)configHolder;
        ServiceAddress newAddress = config.isUdpPortSet() ? new ServiceAddress(false, config.getBasicConfig().getAddress(), config.getUdpPort()) : new ServiceAddress(false, config.getBasicConfig().getAddress(), AccessPointType.LANCOM.getDefaultPort());
        return newAddress;
    }

    @Override
    public ServiceAddress createServiceAddress(BasicConfigHolder configHolder) {
        ServiceAddress newAddress = new ServiceAddress(false, configHolder.getAddress(), configHolder.isSet(BasicFields.PORT) ? configHolder.getPort() : AccessPointType.LANCOM.getDefaultPort());
        return newAddress;
    }

    @Override
    public ServiceAddress createDummyServiceAddress(EnvironmentProperties env) {
        return new ServiceAddress(false, "", 80);
    }

    @Override
    public void receive(ModuleSpecificSettings settings) {
    }
}

